% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSEbootLS.R
\name{application}
\alias{application}
\title{Calculate the bootstrap LSE for a long memory model}
\usage{
application(
  formula,
  data,
  start,
  d.order,
  s.order,
  N,
  S,
  B = 1,
  nr.cores = 1,
  seed = 123
)
}
\arguments{
\item{formula}{(type: formula) an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under ‘Details’.}

\item{data}{(type: data.frame) data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model.}

\item{start}{(type: numeric) numeric vector, initial values for parameters to run the model.}

\item{d.order}{(type: numeric) polynomial order, where d is the ARFIMA parameter.}

\item{s.order}{(type: numeric) polynomial order noise scale factor.}

\item{N}{(type: numeric) sample size of each block.}

\item{S}{(type: numeric) shifting places from block to block. Observe that the number of blocks M is determined by the following formula \eqn{M = \left\lfloor \frac{T-N}{S} + 1 \right\rfloor}, where \eqn{\left\lfloor . \right\rfloor} takes a single numeric argument \code{x} and returns a numeric vector containing the integers formed by truncating the values in \code{x} toward \code{0}.}

\item{B}{(type: numeric) bootstrap replicates, 1 by default.}

\item{nr.cores}{(type: numeric) number of CPU cores to be used for parallel processing. 1 by default.}

\item{seed}{(type: numeric) random number generator seed to generate the bootstrap samples.}
}
\value{
A list with the following elements:
\itemize{
\item \code{coeff}: A tibble of estimated model coefficients, including intercepts, regression coefficients (\eqn{\beta}), and coefficients of the \eqn{\delta} and \eqn{\alpha} polynomials. Contains columns for coefficient name, estimate, t-value and p-value.
\item \code{estimation}: A matrix of bootstrap replicates for regression coefficients (\eqn{\beta}).
\item \code{delta}: A matrix of bootstrap replicates for the \eqn{\delta} polynomial coefficients.
\item \code{alpha}: A matrix of bootstrap replicates for the \eqn{\alpha} polynomial coefficients.
}
}
\description{
Bootstrap procedure to approximate the sampling distribution of the LSE for
time series linear regression with errors following a Locally Stationary process.
}
\details{
This function estimates the parameters in the linear regression model for \eqn{t = 1, ..., T},

\deqn{Y_{t,T} = X_{t,T} \beta + \epsilon_{t,T},}

where the error term \eqn{\epsilon_{t,T}} follows a Locally Stationary Autoregressive Fractionally Integrated Moving Average (LS-ARFIMA) structure, given by:

\deqn{\epsilon_{t,T} =(1 - B)^{-d(u)} \sigma(u)\eta_t,}

where u=t/T in [0,1], \eqn{d(u)} represents the long-memory parameter, \eqn{\sigma(u)} is the noise scale factor, and \eqn{\{\eta_t\}} is a white noise sequence with zero mean and unit variance.

Particularly, we model \eqn{d(u)} and \eqn{\sigma(u)} as polynomials of order \eqn{d.order} and \eqn{s.order} respectively.

\deqn{d(u) = \sum_{i=0}^{d.order} \delta_i u^i,}
\deqn{\sigma(u) = \sum_{j=0}^{s.order} \alpha_j u^j,}

For more details, see references.
}
\examples{
n    <- length(USinf)
shift<-201
u1<-c((1:shift)/shift,rep(0, n-shift))
u2<-c(rep(0, shift),(1:(n-shift))/(n-shift))
u<-(1:n)/n
switch <- c(rep(1,shift), rep(0, n-shift))
x1<-switch*u
x2<-(1-switch)*u

test <- data.frame(USinf, x1=x1, x2=x2)

application(formula=USinf~x1+x2,data=test,N=150,S=50,B=10,
start = c(0.16,2.0,-7,8,-3,0.25,-0.25,0.01),
d.order=4,s.order=2,nr.cores=1)

}
\references{
Ferreira G., Mateu J., Vilar J.A., Muñoz J. (2020). Bootstrapping regression models with locally stationary disturbances. TEST, 30, 341-363.
}
