% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{BT}
\alias{BT}
\title{At-Sensor Temperature or brightness temperature}
\usage{
BT(Landsat_10, Landsat_11)
}
\arguments{
\item{Landsat_10}{SpatRaster object, Landsat band 10}

\item{Landsat_11}{SpatRaster object, Landsat band 11}
}
\value{
A list containing brightness temperature corresponding to Landsat band 10 and Landsat band 11
}
\description{
This function calculates at-Sensor Temperature or brightness temperature
}
\examples{
a <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(a) = runif(10000, min=27791, max=30878)

b <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(b) = runif(10000, min=25686, max=28069)

BT(Landsat_10 = a, Landsat_11 = b)
}
