% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_terms.R
\name{random_terms}
\alias{random_terms}
\title{Create columns with random numbers for modeling}
\usage{
random_terms(df = 1, rdist = rnorm, args = list(), n, seed = NULL)
}
\arguments{
\item{df}{How many columns to add}

\item{rdist}{Function to generate each column's numbers (default: \code{rnorm})}

\item{args}{A list holding the parameters (if any) to be used for the \code{rdist} argument}

\item{n}{OPTIONALLY, dictate the number of rows in the output}

\item{seed}{Integer seed for the random-number generator}
}
\description{
For demonstration purposes, add the specified number of
random columns to a model matrix. This is intended to be used
in modeling functions, e.g. \code{model_train()}, \code{lm()}, and so on
to explore the extent to which random columns "explain" the
response variable.
}
\details{
\code{random_terms()} will try to guess a suitable value for \code{n} based on
the calling function.
}
\examples{
 mtcars |> model_train(mpg ~ wt + random_terms(4)) |> conf_interval()
 mtcars |> model_train(mpg ~ wt + random_terms(4)) |> anova_summary()
 head(mtcars) |> select(wt, mpg) |> mutate(r = random_terms(3))
}
