% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSWPspec.R
\name{LSWPspec}
\alias{LSWPspec}
\title{Locally Stationary Wavelet Packet Spectral Estimation}
\usage{
LSWPspec(x, lev, bb, wavelet, smooth, spa, correct = TRUE, AA = NULL)
}
\arguments{
\item{x}{a real valued numeric vector containing a time series of dyadic length.}

\item{lev}{the maximum level for which the spectra should be estimated.}

\item{bb}{a wavelet packet basis for which the spectra is estimated.}

\item{wavelet}{wavelet used to estimate the wavelet packet spectra. Possible values are \code{"haar"}, \code{"d4"} and \code{"la8"}. See also Details.}

\item{smooth}{logical. If \code{FALSE} the returned spectral estimate is not smoothed. Default value is \code{FALSE}. See also Details.}

\item{spa}{window length for spectral smoothing. Increasing values increase the smoothing.}

\item{correct}{logical. Should the returned spectral estimate be unbiased? Default is \code{TRUE}.}

\item{AA}{this argument is for internal use only and should be left alone. See also Details.}
}
\value{
A matrix containing the time-frequency spectral estimate where each column corresponds to a different time point and ech row
corresponds to a different packet from the given basis.
}
\description{
\code{LSWPspec} returns the spectral estimate of a locally stationary time series
characterized by a wavelet packet basis.
}
\details{
The current implementation allow the use of these three well known Daubechies discrete wavelets for spectral estimation. Default choice is the
         \code{"la8"} wavelet which has decent control over frequency leakage characterizing compactly supported filters. In this initial implementation
         smoothing is provided by local polynomials through the \code{lowess} function and the smoothing parameter \code{spa} is passed to \code{lowess}.
         Future package versions will allow for different smoothing methods. The argument \code{AA} is tipically used by other functions to provide the
         inner product matrix when running simulations. For a direct usage on a single time series the matrix is calculated internally usig the default settings.
}
\examples{

 wb <- get.wavelet.basis(4)
wpp <- LSWPspec(x = sp500, lev = 4, bb = wb, wavelet = 'la8', smooth = TRUE, spa = 0.35)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{get.wavelet.basis}}, \code{\link{LSWPsim}}, \code{\link{best.basis}}.
}
\author{
Alessandro Cardinali
}
