% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_lucid_all.R
\name{predict_lucid}
\alias{predict_lucid}
\title{Predict cluster assignment and outcome based on LUCID model using new data of G,Z,(Y).
If g_computation, predict cluster assignment, omics data, and outcome based on LUCID model using new data of G only
This function can also be use to extract X assignment is using training data G,Z,Y as input.}
\usage{
predict_lucid(
  model,
  lucid_model = c("early", "parallel", "serial"),
  G,
  Z,
  Y = NULL,
  CoG = NULL,
  CoY = NULL,
  response = TRUE,
  g_computation = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{model}{A model fitted and returned by \code{\link{estimate_lucid}}}

\item{lucid_model}{Specifying LUCID model, "early" for early integration, "parallel" for lucid in parallel
"serial" for lucid in serial.}

\item{G}{Exposures, a numeric vector, matrix, or data frame. Categorical variable
should be transformed into dummy variables. If a matrix or data frame, rows
represent observations and columns correspond to variables.}

\item{Z}{Omics data, if "early", an N by M matrix; If "parallel", a list, each element i is a matrix with N rows and P_i features;
If "serial", a list, each element i is a matrix with N rows and p_i features or a list with two or more matrices with N rows and a certain number of features}

\item{Y}{Outcome, a numeric vector. Categorical variable is not allowed. Binary
outcome should be coded as 0 and 1.}

\item{CoG}{Optional, covariates to be adjusted for estimating the latent cluster.
A numeric vector, matrix or data frame. Categorical variable should be transformed
into dummy variables.}

\item{CoY}{Optional, covariates to be adjusted for estimating the association
between latent cluster and the outcome. A numeric vector, matrix or data frame.
Categorical variable should be transformed into dummy variables.}

\item{response}{If TRUE, when predicting binary outcome, the response will be
returned. If FALSE, the linear predictor is returned.}

\item{g_computation}{If TRUE, the prediction only uses information on G.}

\item{verbose}{A flag indicates whether detailed information
is printed in console. Default is FALSE.}
}
\value{
A list containing the following components:
\enumerate{
\item inclusion.p: A list of inclusion probabilities for each sub-model in the LUCID model.
\item pred.x: A list of predicted values for the data matrix G.
\item pred.y: Predicted values for the response variable Y (if response is TRUE).
\item pred.z: Predicted values for the omics variables Z (if g_computation is TRUE).
}
}
\description{
Predict cluster assignment and outcome based on LUCID model using new data of G,Z,(Y).
If g_computation, predict cluster assignment, omics data, and outcome based on LUCID model using new data of G only
This function can also be use to extract X assignment is using training data G,Z,Y as input.
}
\examples{
# prepare data
G <- sim_data$G
Z <- sim_data$Z
Y_normal <- sim_data$Y_normal

# fit lucid model
fit1 <- estimate_lucid(G = G, Z = Z, Y = Y_normal, lucid_model = "early", K = 2, family = "normal")

# prediction on training set
pred1 <- predict_lucid(model = fit1, G = G, Z = Z, Y = Y_normal, lucid_model = "early")
pred2 <- predict_lucid(model = fit1, G = G, Z = Z, lucid_model = "early")

}
