% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_latent.R
\name{to_latent}
\alias{to_latent}
\title{The Function for Transforming Qualitative/Categorical Variables into Latent Variables in \code{LVGP} Package}
\usage{
to_latent(X_qual, lvs_qual, n_lvs_qual, p_qual, z_vec, dim_z, k)
}
\arguments{
\item{X_qual}{Matrix or data frame containing (only) the qualitative/categorical data.}

\item{lvs_qual}{List containing levels of each qualitative variable}

\item{n_lvs_qual}{Number of levels of each qualitative variable}

\item{p_qual}{Number of qualitative variables}

\item{z_vec}{Latent variable parameters, i.e., latent variable values for each level of qualitative/categorical variables}

\item{dim_z}{Dimensionality of latent variables, usually 1 or 2}

\item{k}{Number of data points, equal to \code{nrow(X_qual)}}
}
\value{
Matrix containing transformed data
}
\description{
Transforms qualitative/categorical variables into latent variables.
}
\note{
This function is \strong{NOT} exported once the LVGP package is loaded.
}
\examples{
# see the examples in the documentation of the function LVGP_fit.
}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\seealso{
\code{\link[LVGP]{LVGP_fit}} to see how a GP model can be fitted to a training dataset.\cr
\code{\link[LVGP]{LVGP_predict}} to use the fitted LVGP model for prediction.\cr
\code{\link[LVGP]{LVGP_plot}} to plot the features of the fitted model.
}
