% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap.LambertW_fit}
\title{Bootstrap Lambert W x F estimates}
\usage{
bootstrap(object, ...)

\method{bootstrap}{LambertW_fit}(object, sample.size = length(object$data), R = 100, ...)
}
\arguments{
\item{object}{an object of class \code{"LambertW_fit"}; usually
output of \code{\link{IGMM}} or \code{\link{MLE_LambertW}}.}

\item{...}{additional arguments passed to \code{\link[boot]{boot}}.}

\item{sample.size}{sample size of the bootstrap.  By default, equal to the 
original data length.}

\item{R}{number of replicates for the bootstrap. See 
\code{\link[boot]{boot}} for details.}
}
\value{
An object of class \code{"boot"} representing the bootstrap 
analysis of \eqn{\hat{\theta}} (or \eqn{\hat{\tau}}) of 
an Lambert W x F estimator (\code{LambertW_fit}).
}
\description{
Analyzes the Lambert W x F for a given dataset based on bootstrapping. Depends
on the \pkg{boot} package and returns a \code{"boot"} object.
}
\examples{
\dontrun{
yy <- rLambertW(n = 1000, theta = list(delta = c(0.1), beta = c(2, 1)), 
                distname = "normal")
mod.igmm <- IGMM(yy, type = "h")
boot.est <- bootstrap(mod.igmm, R = 100) 
# use summary and plot from 'boot' pkg
plot(boot.est, 3)
summary(boot.est)
}
}
