% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indicators.R
\name{get_indicators}
\alias{get_indicators}
\alias{get_indicators,LeMans_param,LeMans_outputs-method}
\alias{get_indicators,LeMans_param,missing-method}
\alias{get_indicators,missing,LeMans_outputs-method}
\alias{get_indicators,missing,missing-method}
\alias{get_LFI}
\alias{get_LFI,LeMans_param,LeMans_outputs-method}
\alias{get_LFI,LeMans_param,missing-method}
\alias{get_LFI,missing,LeMans_outputs-method}
\alias{get_LFI,missing,missing-method}
\alias{get_MML}
\alias{get_MML,LeMans_param,LeMans_outputs-method}
\alias{get_MML,LeMans_param,missing-method}
\alias{get_MML,missing,LeMans_outputs-method}
\alias{get_MML,missing,missing-method}
\alias{get_TyL}
\alias{get_TyL,LeMans_param,LeMans_outputs-method}
\alias{get_TyL,LeMans_param,missing-method}
\alias{get_TyL,missing,LeMans_outputs-method}
\alias{get_TyL,missing,missing-method}
\alias{get_LQ}
\alias{get_LQ,LeMans_param,LeMans_outputs-method}
\alias{get_LQ,LeMans_param,missing-method}
\alias{get_LQ,missing,LeMans_outputs-method}
\alias{get_LQ,missing,missing-method}
\title{Calculate indicators}
\usage{
get_indicators(inputs, outputs, ...)

\S4method{get_indicators}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  prob = 0.5,
  length_LFI = 40
)

\S4method{get_indicators}{LeMans_param,missing}(
  inputs,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  prob = 0.5,
  length_LFI = 40
)

\S4method{get_indicators}{missing,LeMans_outputs}(
  wgt,
  mid,
  l_bound,
  u_bound,
  Linf,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL,
  prob = 0.5,
  length_LFI = 40
)

\S4method{get_indicators}{missing,missing}(
  wgt,
  mid,
  l_bound,
  u_bound,
  Linf,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL,
  prob = 0.5,
  length_LFI = 40
)

get_LFI(inputs, outputs, ...)

\S4method{get_LFI}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  length_LFI = 40
)

\S4method{get_LFI}{LeMans_param,missing}(
  inputs,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  length_LFI = 40
)

\S4method{get_LFI}{missing,LeMans_outputs}(
  wgt,
  l_bound,
  u_bound,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL,
  length_LFI = 40
)

\S4method{get_LFI}{missing,missing}(
  wgt,
  l_bound,
  u_bound,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL,
  length_LFI = 40
)

get_MML(inputs, outputs, ...)

\S4method{get_MML}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3]
)

\S4method{get_MML}{LeMans_param,missing}(inputs, N, species = 1:dim(N)[2], time_steps = 1:dim(N)[3])

\S4method{get_MML}{missing,LeMans_outputs}(
  wgt,
  Linf,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL
)

\S4method{get_MML}{missing,missing}(
  wgt,
  Linf,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL
)

get_TyL(inputs, outputs, ...)

\S4method{get_TyL}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3]
)

\S4method{get_TyL}{LeMans_param,missing}(inputs, N, species = 1:dim(N)[2], time_steps = 1:dim(N)[3])

\S4method{get_TyL}{missing,LeMans_outputs}(
  wgt,
  mid,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL
)

\S4method{get_TyL}{missing,missing}(
  wgt,
  mid,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL
)

get_LQ(inputs, outputs, ...)

\S4method{get_LQ}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  prob = 0.5
)

\S4method{get_LQ}{LeMans_param,missing}(inputs, N, species = 1:dim(N)[2], time_steps = 1:dim(N)[3], prob = 0.5)

\S4method{get_LQ}{missing,LeMans_outputs}(
  wgt,
  u_bound,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL,
  prob = 0.5
)

\S4method{get_LQ}{missing,missing}(
  wgt,
  u_bound,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL,
  prob = 0.5
)
}
\arguments{
\item{inputs}{A \code{\linkS4class{LeMans_param}} object containing the parameter values of the current LeMans model.}

\item{outputs}{A \code{\linkS4class{LeMans_outputs}} object containing the outputs of the model run.}

\item{...}{Additional arguments.}

\item{species}{A numeric value or vector or a character string representing the species that you wish to use to calculate the indicators. The default is \code{1:dim(N)[2]}.}

\item{time_steps}{A numeric vector of the time steps that you wish to use to calculate the indicators. The default is \code{1:dim(N)[3]}.}

\item{prob}{A numeric value or vector between 0 and 1 denoting the length quantiles to be calculated. The default is \code{0.5}.}

\item{length_LFI}{A numeric vector representing the thresholds to be used to calculate the LFI. The default value is \code{40}.}

\item{N}{An array with dimensions \code{nsc}, \code{nfish} and \code{tot_time} representing the number of individuals in each length class for each time step.}

\item{wgt}{A matrix with dimensions \code{nsc} and \code{nfish} representing the weight of each species in each length class.}

\item{mid}{A numeric vector of length \code{nfish} representing the mid-point of the length classes in the model.}

\item{l_bound}{A numeric vector of length \code{nsc} representing the lower bounds of the length classes.}

\item{u_bound}{A numeric vector of length \code{nsc} representing the upper bounds of the length classes.}

\item{Linf}{A numeric vector of length \code{nfish} representing the asymptotic length of each species.}

\item{species_names}{A character vector of length \code{nfish} that denotes the names of the species in the model.}
}
\value{
\code{get_indicators} returns a list object with names `LFI`, `MML`, `TYL` and `LQ`. If \code{length(length_LFI)>1}, `LFI` is a matrix with dimensions \code{length(time_steps)} by \code{length(length_LFI)} where the \code{i,j}th element represents the LFI using the \code{j}th \code{length_LFI} in the \code{i}th \code{time_steps}. If \code{length(length_LFI)==1}, the function will return a numeric vector of length \code{length(time_steps)}. `MML` is a numeric vector of length \code{time_steps} where each element is the MML for the species in \code{species}. `TYL` is a numeric vector of length \code{time_steps} where each element is the TyL for the species in \code{species}. If \code{length(prob)==1}, `LQ` is a matrix with dimensions \code{length(time_steps)} by \code{length(prob)} where the \code{i,j}th element is the LQ using the\code{j}th \code{prob} in the \code{i}th \code{time_steps}. If \code{length(prob)==1}, the function will return a numeric vector of length \code{length(time_steps)}.

If \code{length(length_LFI)==1}, \code{get_LFI} returns a matrix with dimensions \code{length(time_steps)} by \code{length(length_LFI)} where the \code{i,j}th element is the LFI using the \code{j}th \code{length_LFI} in the \code{i}th \code{time_steps}. If \code{length(length_LFI)==1}, the function will return a numeric vector of length \code{length(time_steps)}.

\code{get_MML} returns a numeric vector of length \code{time_steps} where each element is the MML for the species in \code{species}.

If \code{length(prob)>1}, \code{get_LQ} returns a matrix with dimensions \code{length(time_steps)} and \code{length(prob)} where the \code{i,j}th element is the LQ using the the \code{j}th \code{prob} in the \code{i}th \code{time_steps}. If \code{length(prob)==1}, the function will return a numeric vector of length \code{length(time_steps)}.
}
\description{
Calculates Mean Maximum Length (MML), the Large Fish Indicator (LFI), Typical Length (TyL) and Length Quantiles (LQ) of the whole community or a subset of the species.
}
\details{
The LFI represents the proportion of biomass with a length larger than \code{length_LFI}. The MML is the biomass weighted mean of \code{Linf}:

\code{sum(biomass[species]*Linf[species])/sum(biomass[species])}

where \code{biomass} is a numeric vector of length \code{nfish} representing the biomass of each species. TyL is the biomass-weighted geometric mean length of the community:

\code{exp(sum(biomass_*log(mid))/sum(Bio_l))}

where \code{biomass_} is a numeric vector of length \code{nsc} representing the biomass of all the species in each length class. The LQ is the length at which the biomass exceeds a given proportion \code{prob} of the total biomass.
}
\examples{
# Set up and run the model
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=1e12)
effort <- matrix(0.5, 10, dim(NS_params@Qs)[3])
model_run <- run_LeMans(NS_params, years=10, effort=effort)

# Calculate the indicators
get_indicators(inputs=NS_params, outputs=model_run)

# Calculate the LFI
get_LFI(inputs=NS_params, outputs=model_run)

# Calculate MML
get_MML(inputs=NS_params, outputs=model_run)

# Calculate TyL
get_TyL(inputs=NS_params, outputs=model_run)

# Calculate LQs
get_LQ(inputs=NS_params, outputs=model_run)
}
\seealso{
\code{\link{plot_indicators}}
}
