
expect_error(extract_gf("lme(Y ~ 1, data)"), "Can't find random effects.")
expect_error(extract_gf("lme(Y ~ 1, ~1|GF)"), "Can't find random effects.")
expect_error(extract_gf("lme(Y ~ 1, list(School=~1,Class=~1), data)"), "Can't find random effects.")
expect_error(extract_gf("lmer(Y ~ 1+Time+(Time ID), data)"), "Can't find random effects.")
expect_error(extract_gf("lmer(Y ~ 1+Time, data)"), "Can't find random effects.")
expect_error(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=~1 + Time + I(Time^2), data)"), "Double check parentheses in model input.")
expect_error(extract_gf("lme(Y ~ 1 + Time, random=list(~1 + Time), data)"), "Double check random effects notation in model input.")
expect_error(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1,Teacher=~1), data)"), "Can't run function with more than 3 grouping factors.")
expect_error(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2)+(1|GF3)+(1|GF4), data)"), "Can't run function with more than 3 grouping factors.")

test_that("fixed is correct for lmer models", {
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1+Time+I(Time^2)|ID), data)")[[9]], "Y~1+Time+I(Time^2)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1+Time+I(Time^2)|ID), data)")[[9]], "Y~1+Time")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1+Time|ID), data)")[[9]], "Y~1+Time+I(Time^2)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Age-12)+(1+Time+I(Time^2)+I(Age-12)|ID), data)")[[9]], "Y~1+Time+I(Age-12)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1+Time+I(Time^2)+I(Age-12)|ID), data)")[[9]], "Y~1+Time")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Age-12)+I(Time^2)+(1+Time+I(Time^2)+I(Age-12)|ID))")[[9]], "Y~1+Time+I(Age-12)+I(Time^2)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+I(Age-12)+(1+Time+I(Time^2)|ID))")[[9]], "Y~1+Time+I(Time^2)+I(Age-12)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Age-12)+I(Time^2)+(1+Time|ID))")[[9]], "Y~1+Time+I(Age-12)+I(Time^2)")
})
#> Test passed

test_that("random is correct for lmer models", {
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF), data)")[[10]], "(1|GF)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2))")[[10]], "(1|G1:G2)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1+Time|ID), data)")[[10]], "(1+Time|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(Time|ID), data)")[[10]], "(Time|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1+Time||ID), data)")[[10]], "(1+Time||ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(0+Time|ID), data)")[[10]], "(1|ID)+(0+Time|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(Time-1|ID), data)")[[10]], "(1|ID)+(Time-1|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(Time||ID), data)")[[10]], "(Time||ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1+Time+I(Time^2)| ID), data)")[[10]], "(1+Time+I(Time^2)|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1+Time+I(Time^2)|| ID), data)")[[10]], "(1+Time+I(Time^2)||ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)-1| ID), data)")[[10]], "(1|ID)+(Time+I(Time^2)-1|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)+0| ID), data)")[[10]], "(1|ID)+(Time+I(Time^2)+0|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2), data)")[[10]], "(1|GF1)+(1|GF2)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2)+(1|GF3), data)")[[10]], "(1|GF1)+(1|GF2)+(1|GF3)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2)+(1|GF2), data)")[[10]], "(1|G1:G2)+(1|GF2)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|School/Class), data)")[[10]], "(1|School/Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|School)+(1|School:Class))")[[10]], "(1|School)+(1|School:Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|District/School/Class), data)")[[10]], "(1|District/School/Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|District)+(1|District:School)+(1|District:School:Class), data)")[[10]], "(1|District)+(1|District:School)+(1|District:School:Class)")
  expect_equal(extract_gf("lmer(Y ~ FE+(1+FE|School/Class), data)")[[10]], "(1+FE|School/Class)")
  expect_equal(extract_gf("lmer(Y ~ FE+(1+FE|School)+(1|School:Class), data)")[[10]], "(1+FE|School)+(1|School:Class)")
  expect_equal(extract_gf("lmer(Y ~ FE+(1+FE||School/Class), data)")[[10]], "(1+FE||School/Class)")
  expect_equal(extract_gf("lmer(Y ~ FE+(1+FE||School)+(1|School:Class), data)")[[10]], "(1+FE||School)+(1|School:Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2/GF3), data)")[[10]], "(1|GF1)+(1|GF2/GF3)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1/GF2)+(1|GF1/GF3))")[[10]], "(1|GF1/GF2)+(1|GF1/GF3)")
})
#> Test passed

test_that("random is correct for lme models without list", {
  expect_equal(extract_gf("lme(Y ~ 1, random=~1, data)")[[10]], "~1")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|GF)")[[10]], "~1|GF")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|G1:G2, data)")[[10]], "~1|G1:G2")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[10]], "~Time")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time, data)")[[10]], "~1+Time")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag( ~ Time), data)")[[10]], "pdDiag(~Time)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag(~1 + Time))")[[10]], "pdDiag(~1+Time)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[10]], "~Time|ID")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time|ID, data)")[[10]], "~1+Time|ID")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=~1 + Time + I(Time^2)| ID, data)")[[10]], "~1+Time+I(Time^2)|ID")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|School/Class, data)")[[10]], "~1|School/Class")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|District/School/Class, data)")[[10]], "~1|District/School/Class")
  expect_equal(extract_gf("lme(Y ~ FE, random=~1+FE|School/Class)")[[10]], "~1+FE|School/Class")
})
#> Test passed

test_that("random is correct for lme models with list", {
  expect_equal(extract_gf("lme(Y ~ 1, random=list(GF=~1))")[[10]], "list(GF=~1)")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(G1:G2=~1), data)")[[10]], "list(G1:G2=~1)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~1+Time)), data)")[[10]], "list(ID=pdDiag(~1+Time))")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~Time)))")[[10]], "list(ID=pdDiag(~Time))")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=~1 + Time + I(Time^2)), data)")[[10]], "list(ID=~1+Time+I(Time^2))")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[10]], "list(ID=pdDiag(~1+Time+I(Time^2)))")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[10]], "list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1)))")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[10]], "list(School=~1,Class=~1)")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[10]], "list(District=~1,School=~1,Class=~1)")
  expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1))")[[10]], "list(School=~1+FE,Class=~1)")
  expect_equal(extract_gf("lme(Y ~ FE, random=list(School=pdDiag(~1+FE),Class=~1), data)")[[10]], "list(School=pdDiag(~1+FE),Class=~1)")
})
#> Test passed

test_that("re is correct for lmer models", {
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF), data)")[[1]], "(1|GF)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2))")[[1]], "(1|G1G2)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(0+Time|ID), data)")[[1]], "(1|ID)+(0+Time|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(Time-1|ID), data)")[[1]], "(1|ID)+(Time-1|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1+Time+I(Time^2)| ID), data)")[[1]], "(1+Time+I(Time^2)|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1+Time+I(Time^2)|| ID), data)")[[1]], "(1+Time+I(Time^2)||ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)-1| ID), data)")[[1]], "(1|ID)+(Time+I(Time^2)-1|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)+0| ID), data)")[[1]], "(1|ID)+(Time+I(Time^2)+0|ID)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2)+(1|GF3), data)")[[1]], "(1|GF1)+(1|GF2)+(1|GF3)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2)+(1|GF2), data)")[[1]], "(1|G1G2)+(1|GF2)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|School/Class), data)")[[1]], "(1|School)+(1|School:Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|School)+(1|School:Class))")[[1]], "(1|School)+(1|School:Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|District/School/Class), data)")[[1]], "(1|District)+(1|District:School)+(1|District:School:Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|District)+(1|District:School)+(1|District:School:Class), data)")[[1]], "(1|District)+(1|District:School)+(1|District:School:Class)")
  expect_equal(extract_gf("lmer(Y ~ FE+(1+FE|School/Class), data)")[[1]], "(1+FE|School)+(1+FE|School:Class)")
  expect_equal(extract_gf("lmer(Y ~ FE+(1+FE||School/Class), data)")[[1]], "(1+FE||School)+(1+FE||School:Class)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2/GF3), data)")[[1]], "(1|GF1)+(1|GF2)+(1|GF2:GF3)")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1/GF2)+(1|GF1/GF3))")[[1]], "(1|GF1)+(1|GF1:GF2)+(1|GF1)+(1|GF1:GF3)")
})
#> Test passed

test_that("re is correct for lme models without list", {
  expect_equal(extract_gf("lme(Y ~ 1, random=~1, data)")[[1]], "(1|AddGF)")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|GF)")[[1]], "(1|GF)")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|G1:G2, data)")[[1]], "(1|G1G2)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[1]], "(Time|AddGF)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time, data)")[[1]], "(1+Time|AddGF)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag( ~ Time), data)")[[1]], "(Time||AddGF)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag(~1 + Time))")[[1]], "(1+Time||AddGF)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[1]], "(Time|ID)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time|ID, data)")[[1]], "(1+Time|ID)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=~1 + Time + I(Time^2)| ID, data)")[[1]], "(1+Time+I(Time^2)|ID)")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|School/Class, data)")[[1]], "(1|School)+(1|School:Class)")
  expect_equal(extract_gf("lme(Y ~ 1, random=~1|District/School/Class, data)")[[1]], "(1|District)+(1|District:School)+(1|District:School:Class)")
  expect_equal(extract_gf("lme(Y ~ FE, random=~1+FE|School/Class)")[[1]], "(1+FE|School)+(1+FE|School:Class)")
})
#> Test passed

test_that("re is correct for lme models with list", {
  expect_equal(extract_gf("lme(Y ~ 1, random=list(GF=~1))")[[1]], "(1|GF)")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(G1:G2=~1), data)")[[1]], "(1|G1G2)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~1+Time)), data)")[[1]], "(1+Time||ID)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~Time)))")[[1]], "(Time||ID)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=~1 + Time + I(Time^2)), data)")[[1]], "(1+Time+I(Time^2)|ID)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[1]], "(1+Time+I(Time^2)||ID)")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[1]], "(1|ID)+(Time+I(Time^2)-1|ID)")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[1]], "(1|School)+(1|School:Class)")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[1]], "(1|District)+(1|District:School)+(1|District:School:Class)")
  expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1))")[[1]], "(1+FE|School)+(1|School:Class)")
  expect_equal(extract_gf("lme(Y ~ FE, random=list(School=pdDiag(~1+FE),Class=~1), data)")[[1]], "(1+FE||School)+(1|School:Class)")
})
#> Test passed

test_that("gf_description is correct", {
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2))")[[5]], "")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(0+Time|ID), data)")[[5]], "")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(Time-1|ID))")[[5]], "")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)-1| ID), data)")[[5]], "")
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)+0| ID))")[[5]], "")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2)+(1|GF3), data)")[[5]], "crossed")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2)+(1|GF2), data)")[[5]], "crossed")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2/GF3), data)")[[5]], "crossed with nested")
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1/GF2)+(1|GF1/GF3))")[[5]], "crossed within nested")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[5]], "")
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[5]], "")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[5]], "")
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[5]], "")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[5]], "nested")
  expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[5]], "nested")
  expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1))")[[5]], "nested")
})
#> Test passed

test_that("n_gf is correct", {
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2))")[[4]], 1)
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(0+Time|ID), data)")[[4]], 1)
  expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(Time-1|ID))")[[4]], 1)
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)-1| ID), data)")[[4]], 1)
  expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)+0| ID))")[[4]], 1)
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2)+(1|GF3), data)")[[4]], 3)
  expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2)+(1|GF2), data)")[[4]], 2)
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2/GF3), data)")[[4]], 3)
  expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1/GF2)+(1|GF1/GF3))")[[4]], 3)
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[4]], 1)
  expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[4]], 1)
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[4]], 1)
  expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[4]], 1)
  expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[4]], 2)
  expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[4]], 3)
  expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1))")[[4]], 2)
})
#> Test passed





#####################################################

# test_that("TBD is correct", {
#   expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2))")[[1]], "(1|G1G2)")
#   expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(0+Time|ID), data)")[[1]], "(1|ID)+(0+Time|ID)")
#   expect_equal(extract_gf("lmer(Y ~ 1+Time+(1|ID)+(Time-1|ID), data)")[[1]], "(1|ID)+(Time-1|ID)")
#   expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)-1| ID), data)")[[1]], "(1|ID)+(Time+I(Time^2)-1|ID)")
#   expect_equal(extract_gf("lmer(Y ~ 1+Time+I(Time^2)+(1|ID)+(Time+I(Time^2)+0| ID), data)")[[1]], "(1|ID)+(Time+I(Time^2)+0|ID)")
#   expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2)+(1|GF3), data)")[[1]], "(1|GF1)+(1|GF2)+(1|GF3)")
#   expect_equal(extract_gf("lmer(Y ~ 1+(1|G1:G2)+(1|GF2), data)")[[1]], "(1|G1G2)+(1|GF2)")
#   expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1)+(1|GF2/GF3), data)")[[1]], "(1|GF1)+(1|GF2)+(1|GF2:GF3)")
#   expect_equal(extract_gf("lmer(Y ~ 1+(1|GF1/GF2)+(1|GF1/GF3))")[[1]], "(1|GF1)+(1|GF1:GF2)+(1|GF1)+(1|GF1:GF3)")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[1]], "(Time|AddGF)")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[1]], "(Time|ID)")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[1]], "(1+Time+I(Time^2)||ID)")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[1]], "(1|ID)+(Time+I(Time^2)-1|ID)")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[1]], "(1|School)+(1|School:Class)")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[1]], "(1|District)+(1|District:School)+(1|District:School:Class)")
#   expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1))")[[1]], "(1+FE|School)+(1|School:Class)")
# })
#> Test passed


# test_that("random is correct for lmer models", {
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | GF), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | G1:G2), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1 + Time | ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (Time | ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1 + Time || ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1|ID) + (0+Time|ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1|ID) + (Time-1|ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (Time || ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1 + Time + I(Time^2)| ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1 + Time + I(Time^2)|| ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1|ID) + (Time + I(Time^2)-1| ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1|ID) + (Time + I(Time^2)+0| ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | GF1) + (1|GF2), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | GF1) + (1|GF2) + (1|GF3), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | G1:G2) + (1|GF2), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | School) + (1|School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | District/School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1|District) + (1 | District:School) + (1|District:School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE | School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE | School) + (1|School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE || School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE || School) + (1|School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1|GF1) + (1|GF2/GF3), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1|GF1/GF2) + (1|GF1/GF3), data)")[[]], "")
# })
#> Test passed


# test_that("random is correct for lme models without list", {
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|GF, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|G1:G2, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag( ~ Time), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag(~1 + Time), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time|ID, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag( ~ Time)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~1 + Time)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=~1 + Time + I(Time^2)| ID, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|School/Class, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|District/School/Class, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ FE, random=~1+FE|School/Class, data)")[[]], "")
# })
#> Test passed


# test_that("random is correct for lme models with list", {
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(GF=~1), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(G1:G2=~1), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~1+Time)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~Time)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=~1 + Time + I(Time^2)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ FE, random=list(School=pdDiag(~1+FE),Class=~1), data)")[[]], "")
# })
#> Test passed

# test_that("model_call is correct", {
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | GF), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|GF, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(GF=~1), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | G1:G2), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|G1:G2, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(G1:G2=~1), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag( ~ Time), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=pdDiag(~1 + Time), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1 + Time | ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (Time | ID), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~ Time|ID, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=~1+Time|ID, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag( ~ Time)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~1 + Time)), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1 + Time || ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1|ID) + (0+Time|ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (1|ID) + (Time-1|ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + (Time || ID), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~1+Time)), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time, random=list(ID=pdDiag(~Time)), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1 + Time + I(Time^2)| ID), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=~1 + Time + I(Time^2)| ID, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=~1 + Time + I(Time^2)), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1 + Time + I(Time^2)|| ID), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdDiag(~1 + Time + I(Time^2))), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1|ID) + (Time + I(Time^2)-1| ID), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + Time + I(Time^2) + (1|ID) + (Time + I(Time^2)+0| ID), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1 + Time + I(Time^2), random=list(ID=pdBlocked(list(~1,~Time+I(Time^2)-1))), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | GF1) + (1|GF2), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | GF1) + (1|GF2) + (1|GF3), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | G1:G2) + (1|GF2), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | School) + (1|School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|School/Class, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(School=~1,Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1 | District/School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1|District) + (1 | District:School) + (1|District:School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=~1|District/School/Class, data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ 1, random=list(District=~1,School=~1,Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE | School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ FE, random=~1+FE|School/Class, data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE | School) + (1|School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ FE, random=list(School=~1+FE,Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE || School/Class), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ FE + (1 + FE || School) + (1|School:Class), data)")[[]], "")
#   expect_equal(extract_gf("lme(Y ~ FE, random=list(School=pdDiag(~1+FE),Class=~1), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1|GF1) + (1|GF2/GF3), data)")[[]], "")
#   expect_equal(extract_gf("lmer(Y ~ 1 + (1|GF1/GF2) + (1|GF1/GF3), data)")[[]], "")
# })
#> Test passed

