% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unif.R
\name{plotUnif}
\alias{plotUnif}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a Uniform Distribution}
\usage{
plotUnif(min, max, type = "b", col = "black")
}
\arguments{
\item{min}{minimum value of the Uniform distribution.}

\item{max}{maximum value of the Uniform distribution.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotUnif} represents density, distribution and/or quantile functions associated with a Uniform
 distribution with \code{min} and \code{max} the lower and upper limits, respectively.
}
\examples{
min=0 ; max=1
plotUnif(min,max)
plotUnif(min,max,col="red")
plotUnif(min,max,type="q")
plotUnif(min,max,type="dis")
plotUnif(min,max,type="den")
}
