% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance.test.R
\name{variance.test}
\alias{variance.test}
\title{One Sample Variance Test of a Normal Population}
\usage{
variance.test(x = NULL, s = NULL, sc = NULL, smu = NULL, mu = NULL,
  n = NULL, sigma02, alternative = "two.sided", alpha = 0.05,
  plot = TRUE, lwd = 1)
}
\arguments{
\item{x}{a numeric vector containing the sample.}

\item{s}{a single numeric value corresponding with the sample standard deviation.}

\item{sc}{a single numeric value corresponding with the cuasi-standard deviation.}

\item{smu}{if known, a single numeric value corresponding with the estimation of the standard deviation for known population mean.}

\item{mu}{if known, a single numeric value corresponding with the population mean. Even when the user provides smu, mu is still needed.}

\item{n}{a single positive integer corresponding with the sample size; not needed if the sample is provided.}

\item{sigma02}{a single number corresponding with the variance to test.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
"\code{two.sided}" (default), "\code{greater}" or "\code{less}".}

\item{alpha}{a single number in (0,1), significance level.}

\item{plot}{a logical value indicating whether to display a graph including the test statistic value for the sample, its distribution, the rejection region and p-value.}

\item{lwd}{a single number indicating the line width of the plot.}
}
\value{
A list with class "\code{lstest}" and "\code{htest}" containing the following components:
\item{statistic}{the value of the test statistic.}
\item{parameter}{the degrees of freedom of the statistic's distribution.}
\item{p.value}{the p-value of the test.}
\item{estimate}{the cuasi-variance.}
\item{null.value}{the value specified by the null.}
\item{alternative}{a character string describing the alternative.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
\item{alpha}{the significance level.}
\item{dist.name}{a character string indicating the distribution of the test statistic.}
\item{statformula}{a character string with the statistic's formula.}
\item{reject.region}{a character string with the reject region.}
\item{unit}{a character string with the units.}
}
\description{
\code{variance.test} allows to compute hypothesis tests for the variance of a Normal population in both scenarios: known or unknown population mean.
}
\details{
The formula interface is applicable when the user provides the sample or values of the
sample characteristics (cuasi-standard deviation or sample standard deviation).
}
\examples{
x <- rnorm(50, mean = 1, sd = 2)
# unknown population mean
variance.test(x, sigma02 = 3.5)
variance.test(sc = sd(x), n = 50, sigma02 = 3.5)
# known population mean
variance.test(x, sigma02 = 3.5, mu = 1)
smu <- Smu(x, mu = 1)
variance.test(smu = smu, n = 50, sigma02 = 3.5)
}
