% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis_cohort.R
\name{lexis_cohort}
\alias{lexis_cohort}
\title{Emphasize a certain cohort in a Lexis grid}
\usage{
lexis_cohort(lg, cohort, delta = 1, fill = lexisplotr_colours()[3],
  alpha = 0.7)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis_grid()}.}

\item{cohort}{numeric, set the cohort to highlight.}

\item{delta}{numeric, set the size of the age groups. Default is 1.}

\item{fill}{character, set the colour of the rectangle.}

\item{alpha}{numeric, set the level of transparency of the rectangle. Default is \code{0.5}.}
}
\description{
Takes an existing Lexis grid and adds a coloured rectangle to highlight a certain cohort.
}
\details{
Takes an existing Lexis grid and adds a coloured rectangle to the plot. The rectangle will highlight a certain cohort in the Lexis grid.
}
\examples{
library(LexisPlotR)
lg <- lexis_grid(year_start = 1900, year_end = 1905, age_start = 0, age_end = 5)
lexis_cohort(lg = lg, cohort = 1901)
}
\author{
Philipp Ottolinger
}
