% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{fillNAgaps}
\alias{fillNAgaps}
\title{Replace all \code{NA} entries of a vector with the previous non-NA value}
\usage{
fillNAgaps(x, firstBack = FALSE)
}
\arguments{
\item{x}{The vector where NA-values should be filled by repeating the last preceeding non-NA value}

\item{firstBack}{if \code{TRUE}, leading NAs are replaced by the first non-NA
value in the vector, otherwise leading NAs are left untouched.}
}
\value{
vector with NAs properly replaced
}
\description{
Sometimes one has a vector with some gaps (\code{NA}) values, which cause
problems for several numeric functions. This function \code{fillNAgaps} fills
these missing values by inserting the last preceeding non-NA-value. Leading
NA values (at the start of the vector will not be modified). If the
argument \code{firstBack = TRUE}, leading \code{NA}-values are replaced by
the first non-NA value.
Trailing NAs are always replaced by the last previous NA-value.
}
\details{
This code was taken from the R Cookbook:
http://www.cookbook-r.com/Manipulating_data/Filling_in_NAs_with_last_non-NA_value/
LICENSE (from that page): The R code is freely available for use without any restrictions.
In other words: you may reuse the R code for any purpose (and under any license).
}
