% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LoBrA.R
\docType{package}
\name{LoBrA}
\alias{LoBrA}
\title{LoBrA: A package for modeling longitudinal breath data}
\description{
The \code{LoBrA} package provides important data objects and functions to analyze longitudinal metabolomic (breath) data.
}
\section{Introduction}{

Novel metabolomic technologies paved the way for longitudinal analysis of exhaled air 
and online monitoring of fast progressing diseases. 
This package implements an automated analysis approach of longitudinal data from 
different omics technologies, such as ion mobility spectrometry of human exhaled air 
and demonstrates how including temporal signals increases the statistical power in 
biomarker identification. 
It can handel multiple irregular 4D time series data. More precisely, it can simultaniously 
handel the data of multiple experiements each observing multiple components. 
Therefore, it allows repeated measurements of a component, irregular sampling, and unequal 
temporal spacing of the time points.
}

\section{LoBrA Analysis}{

A typical LoBrA analysis is will comprise the following steps

1. Background Screening: Using the function \code{\link{screening}} and \code{\link{selectComponents}} to select the Components that most likely do not originate from background noise.

2. Model Selection: First, a set of spline models based on different number of splits and split positions are generated by the function \code{\link{lobraModelSelection}}. Subsequently, these models are evaluated using different quality criteria, i.e. 'AIC', 'BIC' and 'LogLik'. Finally, the most appropriate model is selected.

3. Evaluation of the non-background components on the selected model, using the longitudinal 'Gouderman' linear mixed effect model in function \code{\link{modelGoudermanLongitudinal}}.
}

\section{Author(s)}{

Maintainer:
Anne-Christin Hauschild [Copyright holder]

Authors:
\itemize{
 \item{Sandrah P. Eckel}
 \item{Jan Baumbach}
}
}

