% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pimp.import.R
\name{pimp.import}
\alias{pimp.import}
\title{Predictor Importance – Variables and Interactions}
\usage{
pimp.import(fit, data, testdata, BSpred, pred, Xs, mtype)
}
\arguments{
\item{fit}{Fitted logic regression tree object containing outcome, model type, and logic tree information.}

\item{data}{In-bag sample (training data).}

\item{testdata}{Out-of-bag sample (test data).}

\item{BSpred}{Number of predictors included in the interactions (includes NOT-ed variables).}

\item{pred}{Number of predictors in the model (used for constructing permuted matrices).}

\item{Xs}{Matrix or data frame of 0/1 values representing all predictor variables.}

\item{mtype}{Model type: \code{"classification"}, \code{"linear"}, \code{"Cox-PH Time-to-Event"}, or \code{"Exp. Time-to-Event"}.}
}
\value{
A list with the following components:
\describe{
\item{single.vimp}{Vector of importance estimates for individual predictors.}
\item{pimp.vimp}{Vector of importance estimates for interactions (pimps).}
\item{Ipimat}{Matrix indicating which predictors (and NOT-ed predictors) are used in each interaction.}
\item{vec.Xvars}{Vector of predictor IDs used in the tree.}
\item{Xids}{Vector of predictor column indices corresponding to \code{vec.Xvars}.}
}
}
\description{
Calculates permutation-based importance measures for individual predictors and interactions
within a logic regression tree in a logic forest.
}
\details{
This function calculates importance measures for each bootstrapped sample by comparing model fit
between the original out-of-bag sample and a permuted out-of-bag sample.
Model fit is evaluated using:
\itemize{
\item Misclassification rate for classification models,
\item Log2 mean squared error for linear regression,
\item Harrell's C-index for survival regression (Cox-PH or exponential time-to-event models).
}
}
\references{
Wolf BJ, Hill EG, Slate EH. Logic Forest: an ensemble classifier for discovering logical combinations of binary markers.
\emph{Bioinformatics}. 2010;26(17):2183–2189. \doi{10.1093/bioinformatics/btq354}
}
\seealso{
\code{\link{logforest}}
}
\author{
Bethany J. Wolf \email{wolfb@musc.edu} \cr
J. Madison Hyer \email{madison.hyer@osumc.edu}
}
\keyword{internal}
