% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-diagnostic.R
\name{diagnostic.PLR}
\alias{diagnostic.PLR}
\title{Diagnostic for the penalized Lorenz regression}
\usage{
diagnostic.PLR(
  object,
  tol = 0.99,
  method = c("union", "intersect", "BIC", "Boot", "CV")
)
}
\arguments{
\item{object}{An object of class \code{"PLR"}.}

\item{tol}{A numeric threshold value used to restrict the PLR path. More specifically, we restrict to pairs (grid,lambda) whose normalized score exceeds \code{tol}. Default value is 0.95.}

\item{method}{A character string specifying the method used to evaluate the scores.
Options are \code{"union"}, \code{"intersect"}, \code{"BIC"}, \code{"Boot"}, and \code{"CV"}.
\describe{
  \item{"BIC"}{The score is the BIC-score.}
  \item{"Boot"}{The score is the OOB-score.}
  \item{"CV"}{The score is the CV-score.}
  \item{"union"}{The threshold requirement must be met for at least one of the selection methods available.}
  \item{"intersect"}{The threshold requirement must be met for all selection methods available.}
}}
}
\value{
A list with two elements:
\describe{
  \item{\code{path}}{The restricted model path, containing only the values of the pair (grid, lambda) that satisfy the threshold criterion.}
  \item{\code{best}}{The best model. It is obtained by considering the pair (grid, lambda) in the restricted path that leads to the sparsest model.
   If several pairs yield the same level of sparsity, we consider the pair that maximizes the minimum score across all selection methods available.}
}
}
\description{
\code{diagnostic.PLR} provides diagnostic information for an object of class \code{"PLR"}
It restricts the path of the PLR to pairs of parameters (grid, lambda) that satisfy a threshold criterion.
}
\examples{
\dontshow{
utils::example(Lorenz.boot, echo = FALSE)
}
# Continuing the  Lorenz.boot(.) example:
# The out-of-bag score seems to remain relatively flat when lambda is small enough
plot(PLR_boot, type = "diagnostic")
# What is the best pair (grid,penalty) parameter that is close enough to the highest OOB score
diagnostic.PLR(PLR_boot, tol = 0.99, method = "Boot")
# We want the solution to be close to the best, for both the BIC and OOB scores.
diagnostic.PLR(PLR_boot, method = "intersect")

}
\seealso{
\code{\link{Lorenz.Reg}}
}
