% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBplotVars.R
\name{MBplotVars}
\alias{MBplotVars}
\title{Customizable Plots of Variables}
\usage{
MBplotVars(
  res,
  axes = c(1, 2),
  which = ifelse(res$call$scale, "correlation", "loading"),
  block = 0,
  select = 0,
  title = NULL,
  size = 2.25
)
}
\arguments{
\item{res}{An object resulting from \code{\link{MBPCA}}, \code{\link{ComDim}}, \code{\link{MBPLS}} or \code{\link{MBWCov}}.}

\item{axes}{Which dimensions should be plotted?}

\item{which}{Either "correlation" or "loading".}

\item{block}{Selection of variables by blocks. A number or integer, possibly a vector, corresponding to the index of the blocks from which the variables should be plotted. For \code{\link{MBPLS}} and \code{\link{MBWCov}} the Y response block corresponds to the index \emph{length(res$call$size.block)+1}. By default, all variables of all blocks are plotted. Only one of \emph{block} and \emph{select} can differ from 0 (the default) both at the same time.}

\item{select}{Selection of variables by index. A number or integer, possibly a vector, corresponding to the index of the variables that should be plotted. For \code{\link{MBPLS}} and \code{\link{MBWCov}} the Y variables index start from \emph{ncol(res$call$X)+1}. By default, all variables of all blocks are plotted. Only one of \emph{block} and \emph{select} can differ from 0 (the default) both at the same time.}

\item{title}{An optional title to be added to the plot.}

\item{size}{The overall size of labels, points, etc.}
}
\value{
The required plot.
}
\description{
Plots variables related information of \code{\link{MBPCA}}, \code{\link{ComDim}}, \code{\link{MBPLS}} or \code{\link{MBWCov}} with several options of customization.
}
\examples{
# Unsupervised example

data(ham)
X=ham$X
block=ham$block
res.mbpca <- MBPCA(X,block, name.block=names(block))
MBplotVars(res.mbpca)

# Supervised example

data(ham)
X=ham$X
block=ham$block
Y=ham$Y
res.mbpls <- MBPLS(X, Y, block, name.block=names(block))
MBplotVars(res.mbpls)

}
\seealso{
\code{\link{plot.MBPCA}} \code{\link{plot.ComDim}} \code{\link{plot.MBPLS}} \code{\link{plot.MBWCov}}
}
