% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.train.R
\name{model.train}
\alias{model.train}
\title{Train Multiple Regression and Produce Model Predictions}
\usage{
model.train(target, data, ntest, nvalid, seed = 123)
}
\arguments{
\item{target}{character string specifying the name of the response variable in the data frame. This
variable is excluded from the predictor set and used as the ground truth for training and
evaluation.}

\item{data}{A data frame containing the predictor variables and the target variable. All columns
except target are treated as predictors.}

\item{ntest}{An integer indicating the number of observations allocated to the test set. This sub-
set is completely held out from model training and validation and is used for final
performance assessment.}

\item{nvalid}{An integer specifying the number of observations assigned to the validation set. Predic-
tions on this subset are used to construct Meta Fuzzy Functions and to tune clustering-related
hyperparameters.}

\item{seed}{An integer used to set the random seed for reproducibility.}
}
\value{
A list containing:
\itemize{
\item \code{pred_matrix_valid}: A numeric matrix of validation-set predictions, where each column
corresponds to a base model.
\item \code{pred_matrix_test}: A numeric matrix of test-set predictions generated by the same base
models.
\item \code{y_valid}: A numeric vector of true response values for the validation set.
\item \code{y_test}: A numeric vector of true response values for the test set.
}
}
\description{
Train multiple base learners and generate prediction matrices for use in the Meta Fuzzy
Function framework.
}
\details{
Splits data into train/validation/test, then fits a suite of base learners and generates predictions
for validation and test. Predictions are returned as matrices with dimension \eqn{N_{test} \times M}.
These matrices are the standard input \eqn{x}{x} for \code{mff()} and \code{tune.mff()}.

Base learners include linear regression, Lasso, Ridge, Elastic Net, Random Forest, XGBoost,
and LightGBM, as implemented by the package dependencies.

If a selected method requires hyperparameter optimization, this optimization is not performed
within the \code{model.train} function. Instead, all hyperparameters are fixed a priori using
commonly accepted default values.

Training base models is not a mandatory step to use the MFF framework. The \code{model.train}
function is provided as a convenience utility only. Users may independently train any number
of prediction methods using external workflows or software and directly supply their
predictions as inputs to the MFF.

Accordingly, the \code{model.train} function can be completely skipped while still fully utilizing the
MFF framework with precomputed model outputs.
}
\examples{
 boston <- MASS::Boston
  result <- model.train(
    target = "medv",
    data = boston,
    ntest = 50,
    nvalid = 50,
    seed = 123
  )

  head(result$pred_matrix_valid)
  head(result$pred_matrix_test)

}
\references{
Breiman, L. (2001). Random forests. \emph{Machine Learning}, 45(1), 5-32.
\doi{10.1023/A:1010933404324}

Chen, T., & Guestrin, C. (2016). XGBoost: A Scalable Tree Boosting System.
In \emph{Proceedings of the 22nd ACM SIGKDD International Conference on Knowledge Discovery and Data Mining},
785-794. \doi{10.1145/2939672.2939785}

Chen, T., He, T., Benesty, M., et al. (2025). \emph{xgboost: Extreme Gradient Boosting}.
R package version 3.1.2.1. \url{https://CRAN.R-project.org/package=xgboost}

Ke, G., Meng, Q., Finley, T., et al. (2017). LightGBM: A highly efficient gradient boosting decision tree.
In \emph{Proceedings of the 31st International Conference on Neural Information Processing Systems},
3149-3157.

Liaw, A., & Wiener, M. (2002). Classification and Regression by randomForest.
\emph{R News}, 2(3), 18-22. \url{https://CRAN.R-project.org/doc/Rnews/}

Shi, Y., Ke, G., Soukhavong, D., et al. (2025). \emph{lightgbm: Light Gradient Boosting Machine}.
R package version 4.6.0. \url{https://CRAN.R-project.org/package=lightgbm}

Tay, J. K., Narasimhan, B., & Hastie, T. (2023). Elastic Net Regularization Paths for All Generalized Linear Models.
\emph{Journal of Statistical Software}, 106(1), 1-31. \doi{10.18637/jss.v106.i01}
}
\seealso{
\code{\link{mff}} for the main framework application,
\code{\link{tune.mff}} for hyperparameter optimization,
}
