% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ECHACRX.R
\name{cubeECHACRX}
\alias{cubeECHACRX}
\title{Inheritance Cube: ECHACRX}
\usage{
cubeECHACRX(
  cHW = 1,
  cEHW = 1,
  cEW1 = 1,
  cEW2 = 1,
  cEH = 1,
  chHW = 0,
  crHW = 0,
  chEHW = 0,
  crEHW = 0,
  ceEW1 = 0,
  crEW1 = 0,
  ceEW2 = 0,
  crEW2 = 0,
  ceEH = 0,
  crEH = 0,
  d1 = 0,
  d2 = 0,
  d3 = 0,
  dHW = 0,
  dEH = 0,
  dEW = 0,
  drHW = 0,
  drEH = 0,
  drEW = 0,
  crossF = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cHW}{Cutting efficiency of drive allele at locus 1}

\item{cEHW}{Cutting efficiency of drive allele, in the presence of ECHACR element, at locus 1}

\item{cEW1}{Cutting efficiency of ECHACR element into W at locus 1}

\item{cEW2}{Cutting efficiency of ECHACR element into W at locus 2}

\item{cEH}{Cutting efficiency of ECHACR element into H}

\item{chHW}{Homing efficiency of drive allele at locus 1}

\item{crHW}{Resistance allele efficiency of drive allele at locus 1}

\item{chEHW}{Homing efficiency of drive allele, in the presence of ECHACR element, at locus 1}

\item{crEHW}{Resistance allele efficiency of drive allele, in the presence of ECHACR element, at locus 1}

\item{ceEW1}{Homing efficiency of ECHACR element into W at locus 1}

\item{crEW1}{Resistance allele efficiency of ECHACR element into W at locus 1}

\item{ceEW2}{Homing efficiency of ECHACR element into W at locus 2}

\item{crEW2}{Resistance allele efficiency of ECHACR element into W at locus 2}

\item{ceEH}{Homing efficiency of ECHACR element into H}

\item{crEH}{Resistance allele efficiency of ECHACR element into H}

\item{d1}{Background mutation rate from W into R allele}

\item{d2}{Background mutation rate from H into R allele}

\item{d3}{Background mutation rate from E into R allele}

\item{dHW}{Female H deposition rate against W}

\item{dEH}{Female E deposition rate against H}

\item{dEW}{Female E deposition rate against W}

\item{drHW}{Female resistance generation rate, from H allele}

\item{drEH}{Female resistance generation rate, from E allele}

\item{drEW}{Female resistance generation rate, from E allele}

\item{crossF}{Female crossover rate. 0 is fully linked, 0.5 is unlinked, 1 is negatively linked}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an X-linked ECHACR construct, it has 5 alleles at the first locus
and 4 alleles at the second.
\itemize{
\item W: Wild-type
\item H: Homing allele
\item E: Eraser allele
\item R: No-cost resistance allele
\item B: Detrimental resistance allele
\item cHW: Rate of homing from H, W -> H transition
\item cEH: Rate of homing from E, H -> E transition
\item cEW2: Rate of homing from E, W -> E transition
}
}
\details{
This inheritance pattern corresponds to the Active Genetic Neutralizing Elements for Halting or Deleting Gene Drives (\doi{10.1016/j.molcel.2020.09.003}) publication.
}
