% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-ShredderY.R
\name{cubeXShredderY}
\alias{cubeXShredderY}
\title{Inheritance Cube: Y-Linked X-Shredder}
\usage{
cubeXShredderY(
  cX = 1,
  crX = 0,
  cB = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cX}{Rate of X shredding (default is 1, complete shredding)}

\item{crX}{Rate of resistance chromosome generation (default is 0)}

\item{cB}{Rate of shredder construct breakdown (default is 0)}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model a Y-linked X-Shredder construct.
This construct resides on the Y chromosome, and chops the X chromosome into
many pieces during male spermatogenesis, destroying the X chromosome. Thus, males
only produce Y gametes. \cr
This drive has 5 alleles at 1 locus:
\itemize{
\item X: Wild-type X chromosome
\item R: X chromosome resistant to destruction by the shredder construct
\item Y: Wild-type Y chromosome
\item A: Attacking Y chromosome, a Y chromosome with the shredder construct
\item B: Broken Y chromosome, a Y chromosome with a defunct shredder construct
}
}
