% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topicmodels.R
\name{ols_bcm_topic}
\alias{ols_bcm_topic}
\alias{ols_bcm_topic.default}
\alias{ols_bcm_topic.formula}
\title{Multiplicative bias-corrected OLS for topic models (BCM-Topic)}
\usage{
ols_bcm_topic(
  Y,
  Q = NULL,
  W,
  S,
  B,
  k,
  data = parent.frame(),
  intercept = TRUE,
  ...
)

\method{ols_bcm_topic}{default}(
  Y,
  Q = NULL,
  W,
  S,
  B,
  k,
  data = parent.frame(),
  intercept = TRUE,
  ...
)

\method{ols_bcm_topic}{formula}(
  Y,
  Q = NULL,
  W,
  S,
  B,
  k,
  data = parent.frame(),
  intercept = TRUE,
  ...
)
}
\arguments{
\item{Y}{numeric response vector, or a one-sided formula}

\item{Q}{numeric matrix of additional controls (if Y is numeric)}

\item{W}{numeric matrix of document-term frequencies}

\item{S}{numeric matrix of topic loadings}

\item{B}{numeric matrix of topic-word distributions}

\item{k}{numeric; bias correction parameter}

\item{data}{data frame (if Y is a formula)}

\item{intercept}{logical; if TRUE, includes an intercept term}

\item{...}{additional arguments}
}
\value{
An object of class \code{mlbc_fit} and \code{mlbc_bcm_topic} with:
\itemize{
\item \code{coef}: bias-corrected coefficient estimates
\item \code{vcov}: adjusted variance-covariance matrix
}
}
\description{
Bias-corrected multiplicative estimator for topic model regression. This method
applies multiplicative bias correction to regressions that include topic proportions
as covariates, accounting for estimation uncertainty in the topic model.
}
\examples{
# Load topic model dataset
data(topic_model_data)

# Extract components
Y <- topic_model_data$estimation_data$ly
Z <- as.matrix(topic_model_data$covars)
theta_full <- as.matrix(topic_model_data$theta_est_full)
beta_full <- as.matrix(topic_model_data$beta_est_full)
lda_data <- as.matrix(topic_model_data$lda_data)

# Apply multiplicative bias correction
kappa <- mean(1.0 / lda_data[, 1]) * sqrt(nrow(lda_data))
S <- matrix(c(1.0, 0.0), nrow = 1)

fit <- ols_bcm_topic(Y, Z, theta_full, S, beta_full, k = kappa)
summary(fit)
}
