#' MLFDR: Mediation analysis using localFDR
#'
#' @param lfdr a vector of local false discovery rates, as output from the function localFDR
#' @param size Target False Discovery rate, default is 0.05
#'
#' @returns A vector of logicals indicating which hypotheses are rejected
#' @export
#'
#' @examples
#' n = 100
#' m = 1000
#' pi = c(0.4, 0.1, 0.3, 0.2)
#' X = rbinom(n, 1, 0.1)
#' M = matrix(nrow = m, ncol = n)
#' Y = matrix(nrow = m, ncol = n)
#' gamma = sample(1:4, m, replace = TRUE, prob = pi)
#' alpha = vector()
#' beta = vector()

#' vec1 = rnorm(m, 0.05, 1)
#' vec2 = rnorm(m, -0.5, 2)

#' alpha = ((gamma==2) + (gamma == 4))*vec1
#' beta = ((gamma ==3) + (gamma == 4))*vec2



#' alpha_hat = vector()
#' beta_hat = vector()
#' var_alpha = c()
#' var_beta = c()
#' p1 = vector()
#' p2 = vector()
#' for(i in 1:m)
#' {
#'   M[i,] = alpha[i]*X + rnorm(n)
#'   Y[i,] = beta[i]*M[i,]  + rnorm(1,0.5)*X + rnorm(n)
#'   obj1 = lm(M[i,] ~  X )
#'   obj2 = lm(Y[i,] ~  M[i,] + X)

#'   table1 = coef(summary(obj1))
#'   table2 = coef(summary(obj2))


#'   alpha_hat[i] = table1["X",1]
#'   beta_hat[i] = table2["M[i, ]",1]
#'   p1[i] = table1["X",4]
#'   p2[i] = table2["M[i, ]",4]
#'   var_alpha[i] = table1["X",2]^2
#'   var_beta[i] = table2["M[i, ]",2]^2
#' }

#' lfdr <- localFDR(alpha_hat, beta_hat, var_alpha, var_beta, twostep = FALSE)
#' print(lfdr$pi)
#' MLFDR(lfdr$lfdr, size = 0.05)

MLFDR <- function(lfdr, size = 0.05){
  m = length(lfdr)
  st.lfdr<-sort(lfdr)
  k=1
  while(k<m && ((1/k)*sum(st.lfdr[1:k])) <= size){
    k=k+1
  }
  k<-k-1
  lfdrk<-st.lfdr[k]
  reject<- lfdr<=lfdrk
  return(reject)
}
