#' An example of table with one-parametric volume functions (adapted uniform French tariffs)
#'
#' The adapted uniform French tariffs are typically used in Slovenia to determine tree volume based on tree DBH
#'
#' @format A data frame with 1196 rows and 5 variables:
#' \describe{
#'   \item{tarifa_class}{Tariff class assigned to the species on the given plot (integer).}
#'   \item{plotID}{Unique plot identifier (character).}
#'   \item{species}{Species name as used in \code{data_NFI} (character).}
#'   \item{v45}{Volume of a reference tree with DBH = 45 cm, in cubic metres (\eqn{m^3}; numeric).}
#'   \item{year}{Calendar year to which the specified tariff applies (integer).}
#' }
#' @export
"data_tariffs"
