% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge_of_lab_and_spectrum}
\alias{merge_of_lab_and_spectrum}
\title{Merge Soil Laboratory Data with Spectral Data}
\usage{
merge_of_lab_and_spectrum(soil_data, data_NaturaSpec_cleaned)
}
\arguments{
\item{soil_data}{A data frame containing soil laboratory measurements (must include a column named \code{LAB_NUM}).}

\item{data_NaturaSpec_cleaned}{A data frame containing cleaned spectral data 
with columns \code{Wavelength}, \code{LAB_NUM}, and reflectance values.}
}
\value{
A list with the following elements:
\describe{
  \item{soil}{Data frame of soil laboratory data (first 8 columns of merged dataset).}
  \item{vnir.matrix}{Matrix of VNIR spectral reflectance values (without metadata columns).}
  \item{j}{List of calibration sample indices for cross-validation (4 sets).}
  \item{rm1, rm2, rm3, rm4}{Vectors of indices corresponding to spectral bands to be removed 
        (detector artifact regions around 1000 nm and 1800 nm).}
  \item{ind}{Indices of spectral bands used for aggregation (columns 7–2146).}
  \item{rmove}{Indices of bands to be excluded from analysis.}
  \item{vars}{Vector of spectral band names retained after removal.}
}
}
\description{
This function merges soil laboratory data with cleaned spectral (VNIR) data, 
performs preprocessing, and prepares inputs for calibration and model building.
}
\details{
The function performs the following steps:
\itemize{
  \item Aggregates spectral data by wavelength and computes mean reflectance values.
  \item Merges the soil and spectral datasets by \code{LAB_NUM}.
  \item Separates soil variables and VNIR spectral matrix.
  \item Creates calibration sample indices using random sampling.
  \item Defines spectral bands to remove (detector artifact areas) and 
        indices to be used in modeling.
}
}
\examples{
\donttest{
merged <- merge_of_lab_and_spectrum(soil_data, data_NaturaSpec_cleaned)
str(merged)
}

}
