#' Detecting the appropriate decomposition technique for minorizing \eqn{c\cdot f}
#'
#' @param Function_name The assembly function that \eqn{f} belongs to.
#' @param coefficient The value of \eqn{c}.
#'
#' @return
#' An integer indicating which decomposition technique should be used for minorizing \eqn{c\cdot f}.
#'
#' @keywords internal
#' @noRd
convexity<-function(Function_name,coefficient)
{
  convexity_list<-c("Power","Exponential")
  concavity_list<-c("Logarithmic")
  special_list<-"Logarithmic_one_minus"
  identity_list<-c("Linear_combination")

  if(Function_name%in%convexity_list)
  {
    property<-1+(coefficient<0)
  }
  if(Function_name%in%concavity_list)
  {
    property<-2-(coefficient<0)
  }
  if(Function_name%in%identity_list)
  {
    property<-0
  }
  if(Function_name%in%special_list)
  {
    property<-2+(coefficient<0)
  }
  return(property) # 0: linear; 1: convex; 2: concave; 3: -log(1-x).
}
