% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMD_Rn.R
\name{MMD_Rn}
\alias{MMD_Rn}
\title{Loci redundancy in sequences}
\usage{
MMD_Rn(datafile, popfile, NL, sourcenames, verbose = FALSE)
}
\arguments{
\item{datafile}{character; Name of the file *.csv (with full path in the file system) containing the genotypes (features) of individuals.}

\item{popfile}{character; Name of the file *.pop (with full path in the file system) containing the genotypes (features) of individuals.}

\item{NL}{integer; number of loci. If larger than the number of available loci in the data set, NL is reduced to the maximum available number of loci.}

\item{sourcenames}{a character vector listing the names of the sources.}

\item{verbose}{boolean (TRUE/FALSE) for the display of a progress bar  (Default FALSE)}
}
\value{
A list with
\enumerate{
\item Number of loci.
\item Number of individuals in sources.
\item Data frame with proportional weight of each population, qs.
\item Number of alleles in the dataset.
\item Value of the alleles in the dataset.
\item Dataframe with two columns: (1) Index of locus. (2) Rn for loci in the original dataset.
\item numerical; index of loci with increasing Rn.
\item Dataframe with two columns: (1) Index of loci sorted by increasing Rn. (2) Value of Rn in increasing order.
\item Runtime.
}
}
\description{
Loci redundancy in sequences
}
\examples{
## This example uses a small dataset stored in the MMD package
datafile <- system.file("extdata", "Campylobacter_10SNP_HlW.csv", package = "MMD")
popfile <- system.file("extdata", "Campylobacter_10SNP_HlW.pop", package = "MMD")

NL <- 100
sourcenames <- c("Cattle","Chicken","Pig","Sheep","WB")

RedundancyLoci <- MMD_Rn(datafile,popfile,NL,sourcenames)

## See more detailed examples in the vignette.

}
\author{
Francisco J. Perez-Reche (Univeristy of Aberdeen)
}
