% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMINP_predict.R
\name{MMINP.predict}
\alias{MMINP.predict}
\title{Predict metabolites from new microbiome samples using MMINP model.}
\usage{
MMINP.predict(model, newdata, minGeneSize = 0.5)
}
\arguments{
\item{model}{List of class \code{"mminp"} or \code{"o2m"}, produced by
\code{\link[MMINP]{MMINP.train}} or \code{\link[OmicsPLS]{o2m}}.}

\item{newdata}{New matrix of microbial genes, each column represents a gene.}

\item{minGeneSize}{A numeric between 0-1, minimal size of genes in model
contained in newdata.}
}
\value{
Predicted Data
}
\description{
This function aims to predict potentially metabolites in new microbial
community using trained MMINP model.
If genes in model are not appear in newdata, then this procedure will fill
them up with 0.
Note that this function does not center or scale the new microbiome matrixs,
you would better do preprocessing on newdata in advance.
}
\details{
The model must be class 'mminp' or 'o2m'.
The column of newdata must be microbial genes.
}
\examples{
data(MMINP_trained_model)
data(test_metag)
test_metag_preprocessed <- MMINP.preprocess(test_metag, normalized = FALSE)
pred_metab <- MMINP.predict(model = MMINP_trained_model$model,
newdata = test_metag_preprocessed)

}
