#'Method of Moments Estimation of Binomial distribution
#'@description function to get the method of moment estimate(s) of binomial distribution
#'@param data A numeric vector.
#'@param size.known logical indicating whether the size of the binomial distribution is known or not.
#'@param size	integer valued parameter of binomial distribution.
#'@param plot logical which controls whether the barplot of the data along with the probability curve of the theoretical binomial distribution with the estimated parameters.
#'@param curvecol color of the theoretical probability curve
#'@param ... additional plotting parameters
#'@importFrom stats dbinom var
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is binomial distribution
#'@examples
#'binom_est(rbinom(1000,size=5,prob=0.2),size.known=TRUE,size=5)#no of trials known
#'binom_est(rbinom(1000,size=10,prob=0.6))
#'@export
binom_est=function(data,size.known=FALSE,size=NULL,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  va.r=var(data)
  if(size.known==FALSE) size=(avg/(1-(va.r/avg)))
  p=avg/round(size)
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dbinom(x,size=round(size),prob=p),from=0,to=round(size),n=round(size)+1,add=TRUE,col=curvecol)
  }
  output=list(round(size),p)
  names(output)=c("size","prob")
  return(output)
}
