#'Method of Moments Estimation of Exponential Distribution
#'@description function to get the method of moment estimate of exponential distribution
#'@param data An object of numeric vector.
#'@param plot logical which controls whether the histogram of the data along with the density curve of the theoretical exponential distribution with the estimated parameters.
#'@param curvecol color of the theoretical density curve
#'@param ... additional plotting parameters
#'@importFrom stats dexp
#'@importFrom graphics hist curve
#'@return the estimated positive rate parameter by the method of moments of the data assuming the underlying distribution is exponential distribution
#'@examples
#'exp_est(rexp(1000,rate=0.1))
#'@export
exp_est=function(data,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dexp(x,rate=(1/avg)),from=0,to=max(data),add=TRUE,col=curvecol)
  }
  output=list((1/avg))
  names(output)=c("rate")
  return(output)
}
