#'Method of Moments Estimation of Gamma distribution
#'@description function to get the method of moment estimate(s) of gamma distribution
#'@param data A numeric vector.
#'@param unknown A character string specifying which parameter is (are) unknown to the user.
#'@param shape,scale	positive shape and scale parameters of the gamma distribution.
#'@param plot logical which controls whether the histogram of the data along with the density curve of the theoretical gamma distribution with the estimated parameters.
#'@param curvecol color of the theoretical density curve
#'@param ... additional plotting parameters
#'@importFrom stats dgamma var
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is gamma distribution
#'@examples
#'gamma_est(rgamma(1000,shape=2,scale=1),unknown="scale",shape=2)#shape is known
#'gamma_est(rgamma(1000,shape=2,scale=1),unknown="shape",scale=1)#scale is known
#'gamma_est(rgamma(1000,shape=2,scale=1),unknown="both")#both will be estimated
#'@export
gamma_est=function(data,unknown=c("shape","scale","both"),shape=NULL,scale=NULL,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  va.r=var(data)
  if(unknown=="scale") scale=avg/shape
  if(unknown=="shape") shape=avg/scale
  if(unknown=="both")
  {
    shape= avg^2/va.r
    scale= va.r/avg
  }
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dgamma(x,shape=shape,scale=scale),add=TRUE,col=curvecol)
  }
  output=list(scale,shape)
  names(output)=c("scale","shape")
  return(output)
}
