#' Set MSUthemes base R graphical parameters
#'
#' @param family Font used for all text elements. Default "Metropolis".
#' @param adj Alignment of text for title. Default 0.
#' @param mar Margins. Default \code{c(5, 3, 3, 2.5)}.
#' @param bty Axis lines. Default "n".
#' @param ... Additional arguments passed to \code{par}
#' @return Returns an invisible named list.
#' @examples
#' # save user's current par values that this function will change
#' oldpar <- par("family", "adj", "mar", "bty")
#' set_msu_par()
#' plot(1:4, 1:4, col=1:4, main = "Title")
#' par(oldpar)
#' @export

set_msu_par <- function(family = "Metropolis",
                           adj = 0,
                           mar = c(5, 3, 3, 2.5),
                           bty = "n",
                           ...) {

  # Check font availability and use fallback if needed
  family <- check_font_available(
    requested_font = family,
    fallback_font = "sans",
    warn = TRUE
  )

  graphics::par(
    family = family,
    adj = adj,
    mar = mar,
    bty = bty,
    ...
  )
}
