% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weighted.matrixModel.R
\name{Weighted.matrixModel}
\alias{Weighted.matrixModel}
\title{Weighted.matrixModel}
\usage{
Weighted.matrixModel(datInput)
}
\arguments{
\item{datInput}{Data frame with column names: Experiment.id, Replicate, Bait,
Prey, and count (i.e., prey count).}
}
\value{
Data frame containing bait-prey pairs with k (i.e.,number of co-purifications) &
logHG (i.e., $-1$*log(P-val) of the hypergeometric test)
}
\description{
This function computes the weighted matrix model for instances
(e.g., bait-prey interactions (BPIs)) in the data.frame.The output of the weighted matrix model
includes the number of experiments for which the pair of proteins is co-purified
(i.e., k) and -1*log(P-value) of the hypergeometric test (i.e., logHG)
given the experimental overlap value, each protein's total number of observed experiments,
and the total number of experiments (Drew et al., 2017).
}
\examples{
data(SampleDatInput)
datScoring <- Weighted.matrixModel(SampleDatInput)
head(datScoring)
}
\references{
Drew, K., Lee, C., Huizar, R. L., Tu, F., Borgeson, B., McWhite, C. D., et al. (2017).
Integration of over 9,000 mass spectrometry experiments builds a global map of human protein complexes.
Mol. Syst. Biol. 13, 932.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
