% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTA.R
\name{MTA}
\alias{MTA}
\title{Function to generate a unit space for the Mahalanobis-Taguchi Adjoint (MTA)
  method}
\usage{
MTA(unit_space_data, includes_transformed_data = FALSE)
}
\arguments{
\item{unit_space_data}{Matrix with n rows (samples) and p columns (variables).
Data to generate the unit space. All data should be
continuous values and should not have missing values.}

\item{includes_transformed_data}{If \code{TRUE}, then the transformed data
are included in a return object.}
}
\value{
\code{MTA} returns an object of S3 \link[base]{class} "MTA". An
          object of class "MTA" is a list containing the following components:

 \item{A}{p x p (q x q) matrix. Cofactor matrix of \code{unit_space_data}
           (the transformed data).}
 \item{calc_A}{\code{calc_cofactor}.}
 \item{transforms_data}{Function to be generated from the
                         \code{\link{generates_normalization_function}} based
                         on the \code{unit_space_data}.}
 \item{distance}{Vector with length n. Distances from the unit space to each
                  sample.}
 \item{n}{The number of samples.}
 \item{q}{The number of variables after the data transformation. q equals p.}
 \item{x}{If \code{includes_transformed_data} is \code{TRUE}, then the
           transformed data are included.}
}
\description{
\code{MTA} generates a unit space for the Mahalanobis-Taguchi Adjoint (MTA)
  method. In \code{\link{general_MT}}, cofactor matrix is used for A and
  the data are normalized based on \code{unit_space_data}.
}
\examples{
# 40 data for versicolor in the iris dataset
iris_versicolor <- iris[61:100, -5]

unit_space_MTA <- MTA(unit_space_data = iris_versicolor,
                      includes_transformed_data = TRUE)

(unit_space_MTA$distance)

}
\references{
Taguchi, G. & Kanetaka, T. (2002). \emph{Engineering Technical Development
    in MT System - Lecture on Applied Quality.} Japanese Standards
    Association. (In Japanese)

  Taguchi, G., & Jugulum, R. (2002). \emph{The Mahalanobis-Taguchi strategy:
    A pattern technology system.} John Wiley & Sons.
}
\seealso{
\code{\link{calc_cofactor}}, \code{\link{general_MT}},
           \code{\link{generates_normalization_function}}, and
           \code{\link{diagnosis.MT}}
}

