% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplotPLS.R
\name{biplotPLS}
\alias{biplotPLS}
\title{PLS biplot}
\usage{
biplotPLS(
  fit,
  comps = 1:2,
  xCol,
  labPlSc = TRUE,
  labs,
  vars,
  labPlLo = TRUE,
  pchSc = 16,
  colSc,
  colLo = 2,
  supLeg = FALSE
)
}
\arguments{
\item{fit}{A PLS fit (e.g. from MUVRclassObject$Fit[[2]])}

\item{comps}{Which components to plot}

\item{xCol}{(Optional) Continuous vector for grey scale gradient of observation (sample) color (e.g. Y vector in regression analysis)}

\item{labPlSc}{Boolean to plot observation (sample) names (defaults to TRUE)}

\item{labs}{(Optional) Label names}

\item{vars}{Which variables to plot (names in rownames(loadings))}

\item{labPlLo}{Boolean to plot variable names (defaults to TRUE)}

\item{pchSc}{Plotting character for observation scores}

\item{colSc}{Colors for observation scores (only if xCol omitted)}

\item{colLo}{Colors for variable loadings (defaults to red)}

\item{supLeg}{Boolean for whether to suppress legends}
}
\value{
A PLS biplot
}
\description{
Makes a biplot of a fitted object (e.g. from a MUVR with PLS core).
}
\examples{
\donttest{
data("freelive2")
nRep <- 2 # Number of MUVR2 repetitions
nOuter <- 3 # Number of outer cross-validation segments
varRatio <- 0.75 # Proportion of variables kept per iteration
method <- 'PLS' # Selected core modeling algorithm
regrModel <- MUVR2(X = XRVIP2,
                  Y = YR2,
                  nRep = nRep,
                  nOuter = nOuter,
                  method = method,
                  modReturn = TRUE)
biplotPLS(regrModel$Fit[[2]],
          comps = 1:2,
          xCol = YR2,
          labPlSc = FALSE,
          labPlLo = FALSE)
}
}
