% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeModels.R
\name{mergeModels}
\alias{mergeModels}
\title{Merge two MUVR class objects}
\usage{
mergeModels(MV1, MV2)
}
\arguments{
\item{MV1}{a MUVR class Object}

\item{MV2}{a MUVR class Object}
}
\value{
A merged MURV class object
}
\description{
Merge two MUVR class objects that use regression for PLS or RF methods. The resultant MUVR class object has the same indata except that nRep is different.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                  nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn = TRUE)
mergedModel<-mergeModels(regrModel,regrModel)
}
}
