% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{calculate_BMWP}
\alias{calculate_BMWP}
\title{The Biological Monitoring Working Party score (BMWP) This index provides single values, at the family level (with exception of Oligochaete which is to  the order level), representative of the organisms’ tolerance to pollution.}
\usage{
calculate_BMWP(
  dataset,
  Site = "Site",
  tolerances = list(Siphlonuridae = 10, Heptageniidae = 10, Leptophlebiidae = 10,
    Ephemerellidae = 10, Potamanthidae = 10, Ephemeridae = 10, Taeniopterygidae = 10,
    Leuctridae = 10, Capniidae = 10, Perlodidae = 10, Perlidae = 10, Chloroperlidae = 10,
    Aphelocheridae = 10, Phryganeidae = 10, Molannidae = 10, Beraeidae = 10,
    Odontoceridae = 10, Leptoceridae = 10, Goeridae = 10, Lepidostomatidae = 10,
    Brachycentridae = 10, Sericostomatidae = 10, Astacidae = 8, Lestidae = 8, Agriidae =
    8, Gomphidae = 8, Cordulegasteridae = 8, 
     Aeshnidae = 8, Corduliidae = 8,
    Libellulidae = 8, Caenidae = 7, Nemouridae = 7, Rhyacophilidae = 7, Polycentropodidae
    = 7, Limnephilidae = 7, Neritidae = 6, Viviparidae = 6, Ancylidae = 6, Hydroptilidae
    = 6, Unionidae = 6, Platycnemididae = 6, Coenagriidae = 6, Mesoveliidae = 5,
    Hydrometridae = 5, Gerridae = 5, Nepidae = 5, Naucoridae = 5, Notonectidae = 5,
    Pleidae = 5, Corixidae = 5, Haliplidae = 5, Hygrobiidae = 5, Dytiscidae = 5,
    Gyrinidae = 5, Hydrophilidae = 5, Clambidae = 5, Helodidae = 5, 
     Dryopidae = 5,
    Elmidae = 5, Chrysomelidae = 5, Curculionidae = 5, Hydropsychidae = 5, Tipulidae = 5,
    Simuliidae = 5, Planariidae = 5, Dendrocoelidae = 5, Baetidae = 4, Sialidae = 4,
    Piscicolidae = 4, Valvatidae = 3, Hydrobiidae = 3, Lymnaeidae = 3, Physidae = 3,
    Planorbidae = 3, Sphaeriidae = 3, Glossiphoniidae = 3, Hirudidae = 3, Erpobdellidae =
    3, Asellidae = 3, Chironomidae = 2, Oligochaeta = 1, Cypermethrin = 0),
  print_results = TRUE
)
}
\arguments{
\item{dataset}{Data set must have predefined column names: Family and Site}

\item{Site}{Site should given as default to your data}

\item{tolerances}{tolerance value are given by default}

\item{print_results}{A logical value that determines whether or not to print the results. Defaults to TRUE.}
}
\value{
will give values from 0-100 of BMWP index, Water Quality and Level of Pollution for each Site
}
\description{
The Biological Monitoring Working Party score (BMWP) This index provides single values, at the family level (with exception of Oligochaete which is to  the order level), representative of the organisms’ tolerance to pollution.
}
\examples{
Site= c("L1", "L2", "L2")
Family=c("Capniidae",  "Aeshnidae", "Chloroperlidae")
test <- data.frame( Family, Site)
calculate_BMWP(test)

}
\references{
Paisley M.F., Trigg D.J. & Walley W.J. 2013. Revision of the Biological Monitoring Working Party (BMWP) Score System: Derivation of present-only and abundance-related scores from field data. River Res. Appl. 30 (7): 887–904. DOI: 10.1002/rra.2686

Zeybek M., Kalyoncu H., Karakaş B. & Özgül S. 2014. The use of BMWP and ASPT indices for evaluation of water quality according to macroinvertebrates in Değirmendere Stream (Isparta, Turkey). Turk. J. Zool. 38: 603–613. DOI: 10.3906/zoo-1310-9

Arslan, N., Salur, A., Kalyoncu, H. et al. The use of BMWP and ASPT indices for evaluation of water quality according to macroinvertebrates in Küçük Menderes River (Turkey). Biologia 71, 49–57 (2016). https://doi.org/10.1515/biolog-2016-0005

Biological Monitoring Working Party Final Report: Assessment and Presentation of Biological Quality of Rivers in Great Britain. December 1978, Department of the Environment, Water Data Unit (1978), p. 37

L. Li, B. Zheng, L. Liu Biomonitoring and bioindicators used for river ecosystems: definitions, approaches and trends Procedia Environ. Sci., 2 (2010), pp. 1510-1524, 10.1016/j.proenv.2010.10.164

National Water Council River Quality: the 1981 Survey and Future Outlook National Water Council, London, UK (1981), p. 39

J. Alba-Tercedor Macroinvertebrados acuáticos y calidad de las aguas de los ríos. IV Simposio del agua en Andalucía (SIAGA) Almería, 2 (1996), pp. 203-231

S. Guareschi, A. Laini, M.M. Sánchez-Montoya How do low-abundance taxa affect river biomonitoring? Exploring the response of different macroinvertebrate-based indices J. Limnol., 76 (s1) (2017), pp. 9-20, 10.4081/jlimnol.2016.1516

S.E. Mustow Biological monitoring of rivers in Thailand: use and adaptation of the BMWP Score Hydrobiologia, 479 (2002), pp. 199-229
}
