% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantext.r
\name{PMI}
\alias{PMI}
\title{Calculate Pointwise Mutual Information (PMI)}
\usage{
PMI(x)
}
\arguments{
\item{x}{A data frame with columns 'token' and 'doc_id'.}
}
\value{
Returns a data frame where each row represents a unique keyword
(collocation) in the input data. The data frame contains columns
such as 'keyword', representing the keyword, and 'pmi', representing
the PMI score of that keyword. Higher PMI scores indicate a stronger
association between the components of the collocation within the corpus.
}
\description{
This function calculates the PMI for collocations in a given text data.
}
\examples{
data <- data.frame(token = c("word1", "word2"), doc_id = c(1, 1))
pmi_scores <- PMI(data)
}
