% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_y1y0.R
\name{match_y1y0}
\alias{match_y1y0}
\title{Imputing Missing Potential Outcomes with Matching}
\usage{
match_y1y0(X, A, Y, K = 5, method = "euclidean")
}
\arguments{
\item{X}{A matrix representing covariates, where each row represents the
value of a different covariates for an individual.}

\item{A}{A vector representing the treatment received by each individual.}

\item{Y}{A vector representing the observed outcome for each individual.}

\item{K}{When imputing missing potential outcomes, the average number of
similar individuals are taken based on covariates similarity.}

\item{method}{The distance measure to be used. It is a argument embed in
\code{\link[stats]{dist}} function.}
}
\value{
Returns a matrix of completed matches, where each row is the imputed \eqn{(Y^1, Y^0)}
for each individual.
}
\description{
Impute missing potential outcomes for each individual with matching.
}
\details{
Here are the implementation details for the imputation processes.
Denote \eqn{\hat{Y}^0_i} and \eqn{\hat{Y}^1_i} as the imputed potential
outcomes for individual \eqn{i}. Without loss of generality, if \eqn{A_i = 0}, then
\eqn{\hat{Y}^0_i = Y_i}, and \eqn{\hat{Y}^1_i} is the average of outcomes for the \emph{K} units that are the most
similar to the individual \eqn{i}, i.e.,
\deqn{\hat{Y}_i^0 =  \frac 1 K \sum_{j\in\mathcal{J}_K(i)}Y_j,}
where \eqn{\mathcal{J}_K(i)} represents the set of \eqn{K} matched individuals
with \eqn{A_i = 1}, that are the closest to the individual \eqn{i} in terms of
covariates similarity, and vice versa.
}
\examples{
n <- 100
p <- 2
X <- matrix(rnorm(n*p), ncol = p)
A <- sample(c(0,1), n, TRUE)
Y <- A * (2*X[,1]) + X[,2]^2 + rnorm(n)
match_y1y0(X = X, A = A, Y = Y, K =5)
}
