#' @title adjust_Fg
#'
#' @description A function that adjusts zero proportion values to meet the
#'    requirements of beta regression by bounding values of 0 and 1
#'    to 0.001 and 0.999.
#' @param Fg A numeric vector of length n, where each element represents the
#'    proportion of zero counts for a given gene g across cells for subject i.
#' @return A vector of adjusted zero proportions, with values constrained
#'    between 0.001 and 0.999.
#' @export

adjust_Fg <- function(Fg) {
  # Ensure F_g is between 0.001 and 0.999 to avoid edge cases
  Fg <- pmin(pmax(Fg, 0.001), 0.999)
  return(Fg)
}
