% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{diversity}
\alias{diversity}
\title{Shannon diversity index}
\usage{
diversity(x, two.power = FALSE)
}
\arguments{
\item{x}{A membership vector.}

\item{two.power}{Logical, whether return to the value of \eqn{2^{\mathrm{E}(h_{i})}}.}
}
\value{
A numeric value of Shannon diversity index \eqn{\mathrm{E}(h_{i})} or \eqn{2^{\mathrm{E}(h_{i})}}.
}
\description{
Calculate the Shannon diversity index of the memberships of an observation. The base of the logarithm is 2.
}
\details{
Given a membership vector of the \eqn{i^{th}} observation \eqn{h_i}, the Shannon diversity index is defined as
\deqn{\mathrm{E}(h_{i}) = -\sum_{r=1}^k h_{ir} \mathrm{log}_2 (h_{ir}).}
Specifically, in the case of \eqn{h_{ir}=0}, the value of \eqn{h_{ir} \mathrm{log}_2 (h_{ir})} is taken to be 0.
}
\examples{
# Memberships vector
membership1 <- c(0.1, 0.2, 0.3, 0.4)
diversity(membership1)
diversity(membership1, two.power = TRUE)

# Memberships matrix
membership2 <- matrix(c(0.1, 0.2, 0.3, 0.4, 0.3, 0.2, 0.4, 0.1, 0.2, 0.3, 0.1, 0.4),
                      nrow=3, ncol=4, byrow=TRUE)

E <- rep(NA, nrow(membership2))
for(i in 1:nrow(membership2)){
  E[i] <- diversity(membership2[i,])
}
E
}
\author{
Wenxuan Liu
}
