% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictCellType.R
\name{PredictCellType}
\alias{PredictCellType}
\title{Predict cell type annotation from the trained model}
\usage{
PredictCellType(bst_model, predictMatrix, smooth = FALSE, KNeighbor = 5)
}
\arguments{
\item{bst_model}{The boosting model trained from ModelTrain}

\item{predictMatrix}{A wide cell by pattern matrix generated from GenerateInput function}

\item{smooth}{A Boolean variable to indicate whether smooth the matrix (Default: FALSE)}

\item{KNeighbor}{number of knn neighbors to use for smoothing (Default: 5)}
}
\value{
A cell by cell type matrix with confidence score and labeled cell type.
}
\description{
Predict cell type annotation from the trained model
}
\examples{
\dontshow{if (.Platform$OS.type != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qry <- system.file("extdata", "toy.cg", package = "MethScope")
msk <- system.file("extdata", "toy.cm", package = "MethScope")
res <- GenerateInput(qry, msk)
\dontrun{
prediction <- PredictCellType(Liu2021_MouseBrain_P1000,res)
}
\dontshow{\}) # examplesIf}
}
