% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{add_methods}
\alias{add_methods}
\title{Microsoft 365 object accessor methods}
\description{
Methods for the \code{\link[AzureGraph:ms_graph]{AzureGraph::ms_graph}}, \code{\link[AzureGraph:az_user]{AzureGraph::az_user}} and \code{\link[AzureGraph:az_group]{AzureGraph::az_group}} classes.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{## R6 method for class 'az_user'
get_chat(chat_id)

## R6 method for class 'ms_graph'
get_drive(drive_id)

## R6 method for class 'az_user'
get_drive(drive_id = NULL)

## R6 method for class 'az_group'
get_drive(drive_name = NULL, drive_id = NULL)

## R6 method for class 'az_group'
get_plan(plan_title = NULL, plan_id = NULL)

## R6 method for class 'ms_graph'
get_sharepoint_site(site_url = NULL, site_id = NULL)

## R6 method for class 'az_group'
get_sharepoint_site()

## R6 method for class 'ms_graph'
get_team(team_id = NULL)

## R6 method for class 'az_group'
get_team()

## R6 method for class 'az_user'
list_chats(filter = NULL, n = Inf)

## R6 method for class 'az_user'
list_drives(filter = NULL, n = Inf)

## R6 method for class 'az_group'
list_drives(filter = NULL, n = Inf)

## R6 method for class 'az_group'
list_plans(filter = NULL, n = Inf)

## R6 method for class 'az_user'
list_sharepoint_sites(filter = NULL, n = Inf)

## R6 method for class 'az_user'
list_teams(filter = NULL, n = Inf)
}\if{html}{\out{</div>}}
}

\section{Arguments}{

\itemize{
\item \code{drive_name},\code{drive_id}: For \code{get_drive}, the name or ID of the drive or shared document library. Note that only the \code{az_group} method  has the \code{drive_name} argument, as user drives do not have individual names (and most users will only have one drive anyway). For the \code{az_user} and \code{az_group} methods, leaving the argument(s) blank will return the default drive/document library.
\item \code{site_url},\code{site_id}: For \code{ms_graph$get_sharepoint_site()}, the URL and ID of the site. Provide one or the other, but not both.
\item \code{team_name},\code{team_id}: For \code{az_user$get_team()}, the name and ID of the site. Provide one or the other, but not both. For \code{ms_graph$get_team}, you must provide the team ID.
\item \code{plan_title},\code{plan_id}: For \code{az_group$get_plan()}, the title and ID of the site. Provide one or the other, but not both.
\item \verb{filter, n}: See 'List methods' below.
}
}

\section{Details}{

\code{get_sharepoint_site} retrieves a SharePoint site object. The method for the top-level Graph client class requires that you provide either the site URL or ID. The method for the \code{az_group} class will retrieve the site associated with that group, if applicable.

\code{get_drive} retrieves a OneDrive or shared document library, and \code{list_drives} retrieves all such drives/libraries that the user or group has access to. Whether these are personal or business drives depends on the tenant that was specified in \code{AzureGraph::get_graph_login()}/\code{create_graph_login()}: if this was "consumers" or "9188040d-6c67-4c5b-b112-36a304b66dad" (the equivalent GUID), it will be the personal OneDrive. See the examples below.

\code{get_plan} retrieves a plan (not to be confused with a Todo task list), and \code{list_plans} retrieves all plans for a group.

\code{get_team} retrieves a team. The method for the Graph client class requires the team ID. The method for the \code{az_user} class requires either the team name or ID. The method for the \code{az_group} class retrieves the team associated with the group, if it exists.

\code{get_chat} retrieves a one-on-one, group or meeting chat, by ID. \code{list_chats} retrieves all chats that the user is part of.

Note that Teams, SharePoint and OneDrive for Business require a Microsoft 365 Business license, and are available for organisational tenants only. Similarly, only Microsoft 365 groups can have associated sites/teams/plans/drives, not any other kind of group.
}

\section{List methods}{

All \verb{list_*} methods have \code{filter} and \code{n} arguments to limit the number of results. The former should be an \href{https://learn.microsoft.com/en-us/graph/query-parameters#filter-parameter}{OData expression} as a string to filter the result set on. The latter should be a number setting the maximum number of (filtered) results to return. The default values are \code{filter=NULL} and \code{n=Inf}. If \code{n=NULL}, the \code{ms_graph_pager} iterator object is returned instead to allow manual iteration over the results.

Support in the underlying Graph API for OData queries is patchy. Not all endpoints that return lists of objects support filtering, and if they do, they may not allow all of the defined operators. If your filtering expression results in an error, you can carry out the operation without filtering and then filter the results on the client side.
}

\section{Value}{

For \code{get_sharepoint_site}, an object of class \code{ms_site}.

For \code{get_drive}, an object of class \code{ms_drive}. For \code{list_drives}, a list of \code{ms_drive} objects.

For \code{get_plan}, an object of class \code{ms_plan}. For \code{list_plans}, a list of \code{ms_plan} objects.

For \code{get_team}, an object of class \code{ms_team}. For \code{list_teams}, a list of \code{ms_team} objects.

For \code{get_chat}, an object of class \code{ms_chat}. For \code{list_chats}, a list of \code{ms_chat} objects.
}

\examples{
\dontrun{

# 'consumers' tenant -> personal OneDrive for a user
gr <- AzureGraph::get_graph_login("consumers", app="myapp")
me <- gr$get_user()
me$get_drive()

# organisational tenant -> business OneDrive for a user
gr2 <- AzureGraph::get_graph_login("mycompany", app="myapp")
myuser <- gr2$get_user("username@mycompany.onmicrosoft.com")
myuser$get_drive()

# get a site/drive directly from a URL/ID
gr2$get_sharepoint_site("My site")
gr2$get_drive("drive-id")

# site/drive(s) for a group
grp <- gr2$get_group("group-id")
grp$get_sharepoint_site()
grp$list_drives()
grp$get_drive()

}
}
\seealso{
\code{\link{ms_site}}, \code{\link{ms_drive}}, \code{\link{ms_plan}}, \code{\link{ms_team}}, \code{\link{ms_chat}}, \code{\link[AzureGraph:az_user]{AzureGraph::az_user}}, \code{\link[AzureGraph:az_group]{AzureGraph::az_group}}
}
