% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_channel.R
\docType{class}
\name{ms_channel}
\alias{ms_channel}
\title{Teams channel}
\format{
An R6 object of class \code{ms_channel}, inheriting from \code{ms_object}.
}
\description{
Class representing a Microsoft Teams channel.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for the parent drive.
\item \code{type}: Always "channel" for a channel object
\item \code{team_id}: The ID of the parent team.
\item \code{properties}: The item properties (metadata).
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete this channel. By default, ask for confirmation first.
\item \code{update(...)}: Update the channel's properties (metadata) in Microsoft Graph.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the channel.
\item \code{sync_fields()}: Synchronise the R object with the channel metadata in Microsoft Graph.
\item \code{send_message(body, content_type, attachments)}: Sends a new message to the channel. See below.
\item \code{list_messages(filter=NULL, n=50)}: Retrieves the messages in the channel. By default, this is limited to the 50 most recent messages; set the \code{n} argument to change this.
\item \code{get_message(message_id)}: Retrieves a specific message in the channel.
\item \code{delete_message(message_id, confirm=TRUE)}: Deletes a message. Currently the Graph API does not support deleting Teams messages, so this method is disabled.
\item \code{list_files()}: List the files for the channel. See \code{\link{ms_drive}} for the arguments available for this and the file upload/download methods.
\item \code{upload_file()}: Uploads a file to the channel.
\item \code{download_file()}: Downloads a file from the channel.
\item \code{get_folder()}: Retrieves the files folder for the channel, as a \code{\link{ms_drive_item}} object.
\item \code{list_members(filter=NULL, n=Inf)}: Retrieves the members of the channel, as a list of \code{\link{ms_team_member}} objects.
\item \code{get_member(name, email, id)}: Retrieve a specific member of the channel, as a \code{ms_team_member} object. Supply only one of the member name, email address or ID.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{get_channel} and \code{list_channels} methods of the \code{\link{ms_team}} class. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual channel.
}

\section{Messaging}{

To send a message to a channel, use the \code{send_message()} method. This has arguments:
\itemize{
\item \code{body}: The body of the message. This should be a character vector, which will be concatenated into a single string with newline separators. The body can be either plain text or HTML formatted.
\item \code{content_type}: Either "text" (the default) or "html".
\item \code{attachments}: Optional vector of filenames.
\item \code{inline}: Optional vector of image filenames that will be inserted into the body of the message. The images must be PNG or JPEG, and the \code{content_type} argument must be "html" to include inline content.
\item \code{mentions}: Optional vector of @mentions that will be inserted into the body of the message. This should be either an object of one of the following classes, or a list of the same: \code{\link[AzureGraph:az_user]{AzureGraph::az_user}}, \code{\link{ms_team}}, \code{\link{ms_channel}}, \code{\link{ms_team_member}}. The \code{content_type} argument must be "html" to include mentions.
}

Note that message attachments are actually uploaded to the channel's file listing (a directory in the team's primary shared document folder). Support for attachments is somewhat experimental, so if you want to be sure that it works, upload the file separately using the \code{upload_file()} method.
}

\section{List methods}{

All \verb{list_*} methods have \code{filter} and \code{n} arguments to limit the number of results. The former should be an \href{https://learn.microsoft.com/en-us/graph/query-parameters#filter-parameter}{OData expression} as a string to filter the result set on. The latter should be a number setting the maximum number of (filtered) results to return. The default values are \code{filter=NULL} and \code{n=Inf}. If \code{n=NULL}, the \code{ms_graph_pager} iterator object is returned instead to allow manual iteration over the results.

Support in the underlying Graph API for OData queries is patchy. Not all endpoints that return lists of objects support filtering, and if they do, they may not allow all of the defined operators. If your filtering expression results in an error, you can carry out the operation without filtering and then filter the results on the client side.
}

\examples{
\dontrun{

myteam <- get_team("my team")
myteam$list_channels()

chan <- myteam$get_channel()
chan$list_messages()
chan$send_message("hello from R")

# a multi-line message with an attachment
msg_text <- c(
    "message line 1",
    "message line 2",
    "message line 3"
)
chan$send_message(msg_text, attachments="myfile.csv")

# sending an inline image
chan$send_message("", content_type="html", inline="graph.png")

# channel members
chan$list_members()
jane <- chan$get_member("Jane Smith")
bill <- chan$get_member(email="billg@mycompany.com")

# mentioning a team member
chan$send_message("Here is a message", content_type="html", mentions=jane)

# mentioning 2 or more members: use a list
chan$send_message("Here is another message", content_type="html",
    mentions=list(jane, bill))

# mentioning an entire channel or team
chan$send_message("FYI to channel", content_type="html", mentions=chan)
chan$send_message("FYI to everyone", content_type="html", mentions=myteam)

chan$list_files()

chan$upload_file("mydocument.docx")

}
}
\seealso{
\code{\link{ms_team}}, \code{\link{ms_drive}}, \code{\link{ms_chat_message}}

\href{https://learn.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://learn.microsoft.com/en-us/graph/api/resources/teams-api-overview?view=graph-rest-1.0}{Microsoft Teams API reference}
}
