% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineage_tracing.R
\name{clustering_angular_distance}
\alias{clustering_angular_distance}
\title{clustering_angular_distance}
\usage{
clustering_angular_distance(
  heteroplasmy_matrix,
  allele_matrix,
  cluster,
  top_pos,
  deepSplit_param,
  minClusterSize_param,
  threshold = 0.2,
  min_value,
  index,
  relevant_bases = NULL,
  max_frac = 0.7
)
}
\arguments{
\item{heteroplasmy_matrix}{Third element returned by \emph{get_heteroplasmy}.}

\item{allele_matrix}{Fourth element returned by \emph{get_heteroplasmy}.}

\item{cluster}{Vector specifying a partition of the samples.}

\item{top_pos}{Numeric value. Number of bases sorted with decreasing values
of distance variance (see section \emph{Details} below) among samples. If
\emph{relevant_bases}=NULL, then the bases for performing hierarchical clustering
are the ones whose relative variance (variance of the base divided sum of
variance among \emph{top_pos} bases) is above \emph{min_value}.}

\item{deepSplit_param}{Integer value between 0 and 4 for the \emph{deepSplit}
parameter of the function \emph{cutreeHybrid}. See section \emph{Details}
below.}

\item{minClusterSize_param}{Integer value specifying the \emph{minClusterSize}
parameter of the function \emph{cutreeHybrid}. See section \emph{Details}
below.}

\item{threshold}{Numeric value. If a base has heteroplasmy greater or equal
to \emph{threshold} in more than \emph{max_frac} of cells, then the base is
not considered for down stream analysis.}

\item{min_value}{Numeric value. If \emph{relevant_bases}=NULL, then the bases for
performing hierarchical clustering are the ones whose relative variance
(variance of the base divided sum of variance among \emph{top_pos} bases) is
above \emph{min_value}.}

\item{index}{Fifth element returned by \emph{get_heteroplasmy}.}

\item{relevant_bases}{Character vector of bases to consider as features for
performing hierarchical clustering on samples.Default=NULL.}

\item{max_frac}{Numeric value.If a base has heteroplasmy greater or equal to
\emph{threshold} in more than \emph{max_frac} of cells, then the base is not
considered for down stream analysis.}
}
\value{
It returns a list with 4 elements: \item{classification}{ Dataframe with
two columns and n_row equal to n_row in heteroplasmy_matrix. The first
column is the old cluster annotation provided by cluster. The second columns
is the new cluster annotation obtained with hierarchical clustering on
distance matrix based on heteroplasmy values.

}

\item{dist_ang_matrix}{ Distance matrix based on heteroplasmy values as defined
in the section \emph{Details}

}

\item{top_bases_dist}{ Vector of bases used for hierarchical clustering. If
\emph{relevant_bases} is not NULL, then \emph{top_bases_dist}=NULL

}

\item{common_idx}{ Vector of indices of samples for which hierarchical
clustering is performed. If \emph{index} is NULL, then \emph{common_idx}=NULL

}
}
\description{
For each pair of samples and for each base, an angular distance matrix is
computed based on the four allele frequencies. Then only the angular
distances corresponding to the relevant_bases are kept. If relevant bases is
NULL, then only the angular distances corresponding to the bases with
relative distance variance among samples above \emph{min_value} are kept .
Finally the distance between each pair of samples is defined as the
euclidean distance of the angular distances corresponding to the bases that
pass the previous filtering step. On this final distance matrix, a
hierarchical clustering approach is performed using the function
\emph{cutreeHybrid} of the package \emph{dynamicTreeCut}.
}
\seealso{
\url{https://www.rdocumentation.org/packages/dynamicTreeCut/versions/1.63-1/topics/cutreeHybrid}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
