% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_test.R
\name{dpt_test}
\alias{dpt_test}
\title{dpt_test}
\usage{
dpt_test(heteroplasmy_matrix, time, index = NULL, method = "GAM")
}
\arguments{
\item{heteroplasmy_matrix}{Third element returned by \emph{get_heteroplasmy}.}

\item{time}{Vector of diffusion pseudo time.}

\item{index}{index returned by \emph{get_heteroplasmy}.}

\item{method}{Character name denoting the method to choose for assigning an
adjusted p value to each of the bases. Can be one of GAM, pearson and
spearman. GAM: For each base, a GAM fit with formula z ~ lo(t) is performed
between the heteroplasmy values (z) and the time (t). The p value from the
table "Anova for Parametric Effects" is then assigned to the base.
pearson,spearman:for each base, a pearson or spearman correlation test is
performed between the heteroplasmy values and the time . The p value
obtained from the test is then assigned to the base. In all the three
possible methods, all the p values are then corrected with the method FDR.}
}
\value{
A data frame with 2 columns and number of rows equal to n_col in
\emph{heteroplasmy_matrix}. In the first column there are the names of the bases
while in the second column there are the adjusted p value.
}
\description{
dpt_test
}
\seealso{
\url{https://www.rdocumentation.org/packages/gam/versions/1.20/topics/gam}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
