#' Asymmetric Third Order Rotatable Designs based on t-designs
#'
#' @param v Number of input factors
#'
#' @return Asymmetric Third Order Rotatable Designs (ATORDs) for a given v.
#'@description Generates asymmetric third order rotatable designs based on t- designs of unequal set sizes for a given number of input factors v (4<=v<=9) with coded levels of the factors. Design size is smaller than the design produced by by method 1 in function ATORDs_I.
#' @export
#'@note
#'The user is given with a set of mixed level response surface designs and after entering the serial number of any of the designs from the displayed set, the chosen design will be generated and displayed.
#' @examples
#'if(interactive()){
#'library(MixedLevelRSDs)
#'}
#' @references
#' 1)Damaraju Raghavarao & Bei Zhou (1998). < doi: 10.1080/03610929808832657>. "Universal optimality of ue 3-designs for a competing effects model".
#'
#' 2) J.S. Mehta and M.N. Das (1968). "Asymmetric rotatable designs and orthogonal transformations".
#'
#' 3) M. Hemavathi, Shashi Shekhar, Eldho Varghese, Seema Jaggi, Bikas Sinha & Nripes Kumar Mandal (2022)<doi: 10.1080/03610926.2021.1944213>."Theoretical developments in response surface designs: an informative review and further thoughts".


ATORDs_II<-function(v){
  print("Please, select the levels for which design to be generated:",quote=F)
  if(v==4){

    print("1)13,13,5,5  2)11,11,11,5 3)7,5,17,5 4)31,31,31,5 5)7,5,17,19",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    type=readline()
    if(type==1){
      B<-matrix(c(0.6,0.8,	0,	0, -0.8,	0.6,	0,	0, 0,	0,	1,	0, 0,	0, 0, 1),nrow=4,byrow=T)
    }
    if(type==2){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0, -0.666666667,	0.666666667,	0.333333333,	0 ,   0.666666667,	0.333333333,	0.666666667,	0,0,	0,	0,	1),nrow=4,byrow=T)
    }
    if(type==3){
      B<-matrix(c(0.577350269,	0.707106781,	0.40824829,	0,   0.577350269,
                  -0.707106781,	0.40824829,	0,  0.577350269,	0,	-0.816496581,	0,  0,	0,	0,	1	),nrow=4,byrow=T)

    }
    if(type==4){
      B<-matrix(c(0.428571429,	-0.857142857,	0.285714286,	0 ,  0.285714286,    0.428571429,	0.857142857,	0,    0.857142857,	0.285714286,	-0.428571429,	0,   0,	0,	0,	1 ),nrow=4,byrow=T)
    }
    if(type==5){
      B<-matrix(c(0.5,	0.707106781,	0.40824829,	0.288675135,   0.5,	-0.707106781,	0.40824829,	0.288675135 ,  0.5,	0,	-0.816496581,	0.288675135, 0.5,	0,	0,	-0.866025404	),nrow=4,byrow=T)
    }
    x<-matrix(c(
      0	,	0	,	1	,	1	,
      0	,	0	,	1	,	-1	,
      0	,	0	,	-1	,	1	,
      0	,	0	,	-1	,	-1	,
      1	,	0	,	1	,	0	,
      1	,	0	,	-1	,	0	,
      -1	,	0	,	1	,	0	,
      -1	,	0	,	-1	,	0	,
      1	,	1	,	0	,	0	,
      1	,	-1	,	0	,	0	,
      -1	,	1	,	0	,	0	,
      -1	,	-1	,	0	,	0	,
      0	,	1	,	0	,	1	,
      0	,	1	,	0	,	-1	,
      0	,	-1	,	0	,	1	,
      0	,	-1	,	0	,	-1	,
      1	,	1	,	-1	,	0	,
      -1	,	1	,	-1	,	0	,
      -1	,	1	,	1	,	0	,
      -1	,	-1	,	1	,	0	,
      1	,	-1	,	-1	,	0	,
      1	,	-1	,	1	,	0	,
      1	,	1	,	1	,	0	,
      -1	,	-1	,	-1	,	0	,
      0	,	1	,	1	,	-1	,
      0	,	-1	,	1	,	-1	,
      0	,	-1	,	1	,	1	,
      0	,	-1	,	-1	,	1	,
      0	,	1	,	-1	,	-1	,
      0	,	1	,	-1	,	1	,
      0	,	1	,	1	,	1	,
      0	,	-1	,	-1	,	-1	,
      1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	1	,
      -1	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	1	,
      1	,	1	,	0	,	1	,
      -1	,	-1	,	0	,	-1	,
      1	,	0	,	1	,	-1	,
      -1	,	0	,	1	,	-1	,
      -1	,	0	,	1	,	1	,
      -1	,	0	,	-1	,	1	,
      1	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	1	,
      1	,	0	,	1	,	1	,
      -1	,	0	,	-1	,	-1	,
      2	,	0	,	0	,	0	,
      -2	,	0	,	0	,	0	,
      0	,	2	,	0	,	0	,
      0	,	-2	,	0	,	0	,
      0	,	0	,	2	,	0	,
      0	,	0	,	-2	,	0	,
      0	,	0	,	0	,	2	,
      0	,	0	,	0	,	-2
    ),nrow=56,byrow=T)

  }

  ######################
  if(v==5){
    print("1)9,7,13,15,5  2)15,15,15,13,13 3)13,13,11,11,5 4)9,7,19,11,11",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    type=readline()
    if(type==1){
      B<-matrix(c(0.5	, 0.707106781,	0.40824829,	0.288675135,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,
                  0.5,	0,	0,	-0.866025404,	0,
                  0,	0,	0,	0,	1
      ),nrow=5,byrow=T)
    }

    if(type==2){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,
                  0,	0,	0,	0.866025404,	0.500000000,
                  0,	0,	0,	-0.5,	0.866025404),nrow=5,byrow=T)

    }
    if(type==3){
      B<-matrix(c(0.866025404,	0.500000000,	0,	0,	0,
                  -0.5,	0.866025404,	0,	0,	0,
                  0,	0,	0.316227766,	0.632455532,	0,
                  0,	0,	0.632455532,	-0.316227766,	0,
                  0,	0,	0,	0,	1),nrow=5,byrow=T)


    }
    if(type==4){
      B<-matrix(c(0.577350269,	0.707106781,	0.40824829,	0,	0,
                  0.577350269,	-0.707106781,	0.40824829,	0,	0,
                  0.577350269,	0,	-0.816496581,	0,	0,
                  0,	0,	0,	0.316227766,	0.632455532,
                  0,	0,	0,	0.632455532,	-0.316227766),nrow=5,byrow=T)


    }
    x<-matrix(c(
      1	,	1	,	1	,	0	,	0	,
      1	,	1	,	-1	,	0	,	0	,
      1	,	-1	,	1	,	0	,	0	,
      1	,	-1	,	-1	,	0	,	0	,
      -1	,	1	,	1	,	0	,	0	,
      -1	,	1	,	-1	,	0	,	0	,
      -1	,	-1	,	1	,	0	,	0	,
      -1	,	-1	,	-1	,	0	,	0	,
      1	,	1	,	0	,	1	,	0	,
      1	,	1	,	0	,	-1	,	0	,
      1	,	-1	,	0	,	1	,	0	,
      1	,	-1	,	0	,	-1	,	0	,
      -1	,	1	,	0	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	0	,
      -1	,	-1	,	0	,	1	,	0	,
      -1	,	-1	,	0	,	-1	,	0	,
      1	,	1	,	0	,	0	,	1	,
      1	,	1	,	0	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	1	,
      1	,	-1	,	0	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	1	,	1	,	0	,
      1	,	0	,	1	,	-1	,	0	,
      1	,	0	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	-1	,	0	,
      -1	,	0	,	1	,	1	,	0	,
      -1	,	0	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	1	,
      1	,	0	,	1	,	0	,	-1	,
      1	,	0	,	-1	,	0	,	1	,
      1	,	0	,	-1	,	0	,	-1	,
      -1	,	0	,	1	,	0	,	1	,
      -1	,	0	,	1	,	0	,	-1	,
      -1	,	0	,	-1	,	0	,	1	,
      -1	,	0	,	-1	,	0	,	-1	,
      1	,	0	,	0	,	1	,	1	,
      1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	0	,	-1	,	-1	,
      0	,	1	,	1	,	1	,	0	,
      0	,	1	,	1	,	-1	,	0	,
      0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	1	,	0	,	1	,
      0	,	1	,	1	,	0	,	-1	,
      0	,	1	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	0	,	-1	,
      0	,	-1	,	1	,	0	,	1	,
      0	,	-1	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	0	,	-1	,
      0	,	1	,	0	,	1	,	1	,
      0	,	1	,	0	,	1	,	-1	,
      0	,	1	,	0	,	-1	,	1	,
      0	,	1	,	0	,	-1	,	-1	,
      0	,	-1	,	0	,	1	,	1	,
      0	,	-1	,	0	,	1	,	-1	,
      0	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	0	,	-1	,	-1	,
      0	,	0	,	1	,	1	,	1	,
      0	,	0	,	1	,	1	,	-1	,
      0	,	0	,	1	,	-1	,	1	,
      0	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	-1	,	1	,	1	,
      0	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	-1	,	-1	,	-1	,
      1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	0	,	0	,	0	,
      1	,	0	,	1	,	0	,	0	,
      1	,	0	,	-1	,	0	,	0	,
      -1	,	0	,	1	,	0	,	0	,
      -1	,	0	,	-1	,	0	,	0	,
      1	,	0	,	0	,	1	,	0	,
      1	,	0	,	0	,	-1	,	0	,
      -1	,	0	,	0	,	1	,	0	,
      -1	,	0	,	0	,	-1	,	0	,
      1	,	0	,	0	,	0	,	1	,
      1	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	0	,	0	,	1	,
      -1	,	0	,	0	,	0	,	-1	,
      0	,	1	,	1	,	0	,	0	,
      0	,	1	,	-1	,	0	,	0	,
      0	,	-1	,	1	,	0	,	0	,
      0	,	-1	,	-1	,	0	,	0	,
      0	,	1	,	0	,	1	,	0	,
      0	,	1	,	0	,	-1	,	0	,
      0	,	-1	,	0	,	1	,	0	,
      0	,	-1	,	0	,	-1	,	0	,
      0	,	1	,	0	,	0	,	1	,
      0	,	1	,	0	,	0	,	-1	,
      0	,	-1	,	0	,	0	,	1	,
      0	,	-1	,	0	,	0	,	-1	,
      0	,	0	,	1	,	1	,	0	,
      0	,	0	,	1	,	-1	,	0	,
      0	,	0	,	-1	,	1	,	0	,
      0	,	0	,	-1	,	-1	,	0	,
      0	,	0	,	1	,	0	,	1	,
      0	,	0	,	1	,	0	,	-1	,
      0	,	0	,	-1	,	0	,	1	,
      0	,	0	,	-1	,	0	,	-1	,
      0	,	0	,	0	,	1	,	1	,
      0	,	0	,	0	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,
      2.23606798	,	0	,	0	,	0	,	0	,
      -2.23606798	,	0	,	0	,	0	,	0	,
      0	,	2.23606798	,	0	,	0	,	0	,
      0	,	-2.23606798	,	0	,	0	,	0	,
      0	,	0	,	2.23606798	,	0	,	0	,
      0	,	0	,	-2.23606798	,	0	,	0	,
      0	,	0	,	0	,	2.23606798	,	0	,
      0	,	0	,	0	,	-2.23606798	,	0	,
      0	,	0	,	0	,	0	,	2.23606798	,
      0	,	0	,	0	,	0	,	-2.23606798

    ),nrow=130,byrow=T)

  }
  ################
  if(v==6){
    print("1)15,15,15,13,13,5 2)9,7,19,21,5,5 3)11,25,7,19,21,5 4)9,7,19,11,11,5",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    type=readline()
    if(type==1){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,
                  0,	0,	0,	0.6,	0.8,	0,
                  0,	0,	0,	-0.8,	0.6,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)
    }
    if(type==2){
      B<-matrix(c(0.5	, 0.707106781,	0.40824829,	0.288675135,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,
                  0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)

    }
    if(type==3){
      B<-matrix(c(0.447213595,	0.223606798,	0.707106781,	0.40824829,	0.288675135,	0,
                  0.447213595,	0.223606798,	-0.707106781,	0.40824829,	0.288675135,	0,
                  0.447213595,	0.223606798,	0,	-0.816496581,	0.288675135,	0,
                  0.447213595,	0.223606798,	0,	0,	-0.866025404,	0,
                  0.447213595,	-0.894427191,	0,	0,	0,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)

    }
    if(type==4){
      B<-matrix(c(0.577350269,	0.707106781,	0.40824829,	0,	0,	0,
                  0.577350269,	-0.707106781,	0.40824829,	0,	0,	0,
                  0.577350269,	0,	-0.816496581,	0,	0,	0,
                  0,	0,	0,	0.316227766,	0.632455532,	0,
                  0,	0,	0,	0.632455532,	-0.316227766,	0,
                  0,	0,	0,	0,	0,	1),nrow=6,byrow=T)

    }
    x<-matrix(c(
      0	,	0	,	0	,	1	,	1	,	0	,
      0	,	0	,	0	,	1	,	-1	,	0	,
      0	,	0	,	0	,	-1	,	1	,	0	,
      0	,	0	,	0	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	0	,	0	,	1	,
      0	,	-1	,	0	,	0	,	0	,	1	,
      0	,	1	,	0	,	0	,	0	,	-1	,
      0	,	-1	,	0	,	0	,	0	,	-1	,
      1	,	0	,	1	,	0	,	0	,	0	,
      1	,	0	,	-1	,	0	,	0	,	0	,
      -1	,	0	,	1	,	0	,	0	,	0	,
      -1	,	0	,	-1	,	0	,	0	,	0	,
      1	,	1	,	0	,	-1	,	0	,	0	,
      -1	,	1	,	0	,	-1	,	0	,	0	,
      -1	,	1	,	0	,	1	,	0	,	0	,
      -1	,	-1	,	0	,	1	,	0	,	0	,
      1	,	-1	,	0	,	-1	,	0	,	0	,
      1	,	-1	,	0	,	1	,	0	,	0	,
      1	,	1	,	0	,	1	,	0	,	0	,
      -1	,	-1	,	0	,	-1	,	0	,	0	,
      0	,	1	,	1	,	0	,	-1	,	0	,
      0	,	-1	,	1	,	0	,	-1	,	0	,
      0	,	-1	,	1	,	0	,	1	,	0	,
      0	,	-1	,	-1	,	0	,	1	,	0	,
      0	,	1	,	-1	,	0	,	-1	,	0	,
      0	,	1	,	-1	,	0	,	1	,	0	,
      0	,	1	,	1	,	0	,	1	,	0	,
      0	,	-1	,	-1	,	0	,	-1	,	0	,
      0	,	0	,	1	,	1	,	0	,	-1	,
      0	,	0	,	-1	,	1	,	0	,	-1	,
      0	,	0	,	-1	,	1	,	0	,	1	,
      0	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	0	,	1	,	-1	,	0	,	1	,
      0	,	0	,	1	,	1	,	0	,	1	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,
      -1	,	0	,	0	,	0	,	1	,	1	,
      -1	,	0	,	0	,	0	,	-1	,	1	,
      1	,	0	,	0	,	0	,	-1	,	1	,
      1	,	0	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	0	,	0	,	1	,	-1	,
      1	,	0	,	0	,	0	,	1	,	-1	,
      1	,	0	,	0	,	0	,	1	,	1	,
      -1	,	0	,	0	,	0	,	-1	,	-1	,
      0	,	0	,	1	,	0	,	1	,	-1	,
      0	,	0	,	-1	,	0	,	1	,	-1	,
      0	,	0	,	-1	,	0	,	1	,	1	,
      0	,	0	,	-1	,	0	,	-1	,	1	,
      0	,	0	,	1	,	0	,	-1	,	-1	,
      0	,	0	,	1	,	0	,	-1	,	1	,
      0	,	0	,	1	,	0	,	1	,	1	,
      0	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	0	,	0	,	1	,	0	,	-1	,
      -1	,	0	,	0	,	1	,	0	,	-1	,
      -1	,	0	,	0	,	1	,	0	,	1	,
      -1	,	0	,	0	,	-1	,	0	,	1	,
      1	,	0	,	0	,	-1	,	0	,	-1	,
      1	,	0	,	0	,	-1	,	0	,	1	,
      1	,	0	,	0	,	1	,	0	,	1	,
      -1	,	0	,	0	,	-1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	0	,
      0	,	-1	,	1	,	1	,	0	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	0	,
      0	,	1	,	-1	,	1	,	0	,	0	,
      0	,	1	,	1	,	1	,	0	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	0	,
      1	,	1	,	1	,	0	,	0	,	1	,
      1	,	1	,	1	,	0	,	0	,	-1	,
      1	,	1	,	-1	,	0	,	0	,	1	,
      1	,	1	,	-1	,	0	,	0	,	-1	,
      1	,	-1	,	1	,	0	,	0	,	1	,
      1	,	-1	,	1	,	0	,	0	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	1	,
      1	,	-1	,	-1	,	0	,	0	,	-1	,
      -1	,	1	,	1	,	0	,	0	,	1	,
      -1	,	1	,	1	,	0	,	0	,	-1	,
      -1	,	1	,	-1	,	0	,	0	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	-1	,
      -1	,	-1	,	1	,	0	,	0	,	1	,
      -1	,	-1	,	1	,	0	,	0	,	-1	,
      -1	,	-1	,	-1	,	0	,	0	,	1	,
      -1	,	-1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	-1	,	1	,	0	,
      1	,	0	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	1	,	1	,	0	,
      1	,	0	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	-1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	1	,	1	,	0	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	1	,	1	,	1	,
      0	,	1	,	0	,	1	,	1	,	-1	,
      0	,	1	,	0	,	1	,	-1	,	1	,
      0	,	1	,	0	,	1	,	-1	,	-1	,
      0	,	1	,	0	,	-1	,	1	,	1	,
      0	,	1	,	0	,	-1	,	1	,	-1	,
      0	,	1	,	0	,	-1	,	-1	,	1	,
      0	,	1	,	0	,	-1	,	-1	,	-1	,
      0	,	-1	,	0	,	1	,	1	,	1	,
      0	,	-1	,	0	,	1	,	1	,	-1	,
      0	,	-1	,	0	,	1	,	-1	,	1	,
      0	,	-1	,	0	,	1	,	-1	,	-1	,
      0	,	-1	,	0	,	-1	,	1	,	1	,
      0	,	-1	,	0	,	-1	,	1	,	-1	,
      0	,	-1	,	0	,	-1	,	-1	,	1	,
      0	,	-1	,	0	,	-1	,	-1	,	-1	,
      2.44948974	,	0	,	0	,	0	,	0	,	0	,
      -2.44948974	,	0	,	0	,	0	,	0	,	0	,
      0	,	2.44948974	,	0	,	0	,	0	,	0	,
      0	,	-2.44948974	,	0	,	0	,	0	,	0	,
      0	,	0	,	2.44948974	,	0	,	0	,	0	,
      0	,	0	,	-2.44948974	,	0	,	0	,	0	,
      0	,	0	,	0	,	2.44948974	,	0	,	0	,
      0	,	0	,	0	,	-2.44948974	,	0	,	0	,
      0	,	0	,	0	,	0	,	2.44948974	,	0	,
      0	,	0	,	0	,	0	,	-2.44948974	,	0	,
      0	,	0	,	0	,	0	,	0	,	2.44948974	,
      0	,	0	,	0	,	0	,	0	,	-2.44948974
    ),nrow=136,byrow=T)


  }
  ####################
  if(v==7){
    print("1)9,7,13,7,7,5,5  2)9,7,11,13,13,13,5 3)19,19,19,9,7,19,5 4)19,7,23,11,11,5,5 5)19,19,19,13,13,5,5",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    type=readline()
    if(type==1){
      B<-matrix(c(0.577350269,	0.707106781,	0.40824829,	0,	0,	0,	0,
                  0.577350269,	-0.707106781,	0.40824829,	0,	0,	0,	0,
                  0.577350269,	0,	-0.816496581,	0,	0,	0,	0,
                  0,	0,	0,	0.707106781, 0.707106781,	0,	0,
                  0,	0,	0,	-0.707106781,	0.707106781,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)

    }
    if(type==2){
      B<-matrix(c(0.5,	0.707106781,	0.40824829,	0.288675135,	0,	0,	0,
                  0.5,	-0.707106781,	 0.40824829,	0.288675135,	0,	0,	0,
                  0.5,	0,	-0.816496581,	 0.288675135,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,
                  0,	0,	0,	0,	0.6,	0.8,	0,
                  0,	0,	0,	0,	-0.8,	0.6,	0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)

    }
    if(type==3){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	 0,	0,	0,	0,
                  -0.666666667,	 0.666666667,	 0.333333333,	 0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,
                  0,	0,	0,	0.577350269,	0.707106781,	0.40824829,	0,
                  0,	0,	0,	0.577350269,	-0.707106781,	0.40824829,	0,
                  0,	0,	0,	0.577350269,	0,	-0.816496581,	0,
                  0,	0,	0,	0,	0,	0,	1	),nrow=7,byrow=T)


    }
    if(type==4){
      B<-matrix(c(0.333333333,	0,	-0.942809042,	0,	0,	0,	0,
                  0.666666667,	0.707106781,	0.23570226,	0,	0,	0,	0,
                  0.666666667,	-0.707106781,	0.23570226,	0,	0,	0,	0,
                  0,	0,	0,	0.316227766,	0.632455532,	0,	0,
                  0,	0,	0,	0.632455532,	-0.316227766,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)


    }
    if(type==5){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,
                  0,	0,	0,	0.6,	0.8,	0,	0,
                  0,	0,	0,	-0.8,	0.6,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	1),nrow=7,byrow=T)


    }
    x<-matrix(c(
      1	,	1	,	0	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	0	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	0	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	0	,	1	,	0	,	0	,	0	,
      1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	0	,	1	,	0	,	0	,	0	,
      1	,	1	,	0	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	0	,	-1	,	0	,	0	,	0	,
      0	,	1	,	1	,	0	,	-1	,	0	,	0	,
      0	,	-1	,	1	,	0	,	-1	,	0	,	0	,
      0	,	-1	,	1	,	0	,	1	,	0	,	0	,
      0	,	-1	,	-1	,	0	,	1	,	0	,	0	,
      0	,	1	,	-1	,	0	,	-1	,	0	,	0	,
      0	,	1	,	-1	,	0	,	1	,	0	,	0	,
      0	,	1	,	1	,	0	,	1	,	0	,	0	,
      0	,	-1	,	-1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	1	,	1	,	0	,	-1	,	0	,
      0	,	0	,	-1	,	1	,	0	,	-1	,	0	,
      0	,	0	,	-1	,	1	,	0	,	1	,	0	,
      0	,	0	,	-1	,	-1	,	0	,	1	,	0	,
      0	,	0	,	1	,	-1	,	0	,	-1	,	0	,
      0	,	0	,	1	,	-1	,	0	,	1	,	0	,
      0	,	0	,	1	,	1	,	0	,	1	,	0	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,	0	,
      0	,	0	,	0	,	1	,	1	,	0	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	0	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	0	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	0	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	0	,	1	,
      0	,	0	,	0	,	1	,	1	,	0	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	0	,	-1	,
      -1	,	0	,	0	,	0	,	1	,	1	,	0	,
      -1	,	0	,	0	,	0	,	-1	,	1	,	0	,
      1	,	0	,	0	,	0	,	-1	,	1	,	0	,
      1	,	0	,	0	,	0	,	-1	,	-1	,	0	,
      -1	,	0	,	0	,	0	,	1	,	-1	,	0	,
      1	,	0	,	0	,	0	,	1	,	-1	,	0	,
      1	,	0	,	0	,	0	,	1	,	1	,	0	,
      -1	,	0	,	0	,	0	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	0	,	0	,	1	,	1	,
      0	,	-1	,	0	,	0	,	0	,	-1	,	1	,
      0	,	1	,	0	,	0	,	0	,	-1	,	1	,
      0	,	1	,	0	,	0	,	0	,	-1	,	-1	,
      0	,	-1	,	0	,	0	,	0	,	1	,	-1	,
      0	,	1	,	0	,	0	,	0	,	1	,	-1	,
      0	,	1	,	0	,	0	,	0	,	1	,	1	,
      0	,	-1	,	0	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	0	,	0	,	0	,	1	,
      1	,	0	,	-1	,	0	,	0	,	0	,	-1	,
      1	,	0	,	1	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	1	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	0	,	0	,	0	,	1	,
      -1	,	0	,	1	,	0	,	0	,	0	,	1	,
      1	,	0	,	1	,	0	,	0	,	0	,	1	,
      -1	,	0	,	-1	,	0	,	0	,	0	,	-1	,
      0	,	0	,	1	,	0	,	1	,	1	,	1	,
      0	,	0	,	1	,	0	,	1	,	1	,	-1	,
      0	,	0	,	1	,	0	,	1	,	-1	,	1	,
      0	,	0	,	1	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	1	,	0	,	-1	,	1	,	1	,
      0	,	0	,	1	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	1	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	1	,	0	,	-1	,	-1	,	-1	,
      0	,	0	,	-1	,	0	,	1	,	1	,	1	,
      0	,	0	,	-1	,	0	,	1	,	1	,	-1	,
      0	,	0	,	-1	,	0	,	1	,	-1	,	1	,
      0	,	0	,	-1	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	-1	,	0	,	-1	,	1	,	1	,
      0	,	0	,	-1	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	-1	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,
      1	,	0	,	0	,	1	,	0	,	1	,	1	,
      1	,	0	,	0	,	1	,	0	,	1	,	-1	,
      1	,	0	,	0	,	1	,	0	,	-1	,	1	,
      1	,	0	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	0	,	0	,	-1	,	0	,	1	,	1	,
      1	,	0	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	0	,	0	,	-1	,	0	,	-1	,	1	,
      1	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	0	,	0	,	1	,	0	,	1	,	1	,
      -1	,	0	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	0	,	0	,	1	,	0	,	-1	,	1	,
      -1	,	0	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	0	,	0	,	-1	,	0	,	1	,	1	,
      -1	,	0	,	0	,	-1	,	0	,	1	,	-1	,
      -1	,	0	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	1	,	0	,	0	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,
      1	,	1	,	1	,	0	,	0	,	1	,	0	,
      1	,	1	,	1	,	0	,	0	,	-1	,	0	,
      1	,	1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	1	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	-1	,	0	,	0	,	1	,	0	,
      -1	,	1	,	-1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	-1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	-1	,	0	,	0	,	1	,	0	,
      -1	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
      0	,	1	,	1	,	1	,	0	,	0	,	1	,
      0	,	1	,	1	,	1	,	0	,	0	,	-1	,
      0	,	1	,	1	,	-1	,	0	,	0	,	1	,
      0	,	1	,	1	,	-1	,	0	,	0	,	-1	,
      0	,	1	,	-1	,	1	,	0	,	0	,	1	,
      0	,	1	,	-1	,	1	,	0	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	0	,	0	,	1	,
      0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,
      0	,	-1	,	1	,	1	,	0	,	0	,	1	,
      0	,	-1	,	1	,	1	,	0	,	0	,	-1	,
      0	,	-1	,	1	,	-1	,	0	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,
      0	,	-1	,	-1	,	1	,	0	,	0	,	1	,
      0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,
      0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,
      0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,
      0	,	1	,	0	,	1	,	1	,	1	,	0	,
      0	,	1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	1	,	1	,	1	,	0	,
      0	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      2.64575131	,	0	,	0	,	0	,	0	,	0	,	0	,
      -2.64575131	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	2.64575131	,	0	,	0	,	0	,	0	,	0	,
      0	,	-2.64575131	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	2.64575131	,	0	,	0	,	0	,	0	,
      0	,	0	,	-2.64575131	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	2.64575131	,	0	,	0	,	0	,
      0	,	0	,	0	,	-2.64575131	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	2.64575131	,	0	,	0	,
      0	,	0	,	0	,	0	,	-2.64575131	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	2.64575131	,	0	,
      0	,	0	,	0	,	0	,	0	,	-2.64575131	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	2.64575131	,
      0	,	0	,	0	,	0	,	0	,	0	,	-2.64575131
    ),nrow=182,byrow=T)

  }
  ##########################################
  if(v==8){
    print("1)15,15,15,9,7,13,5,5  2)11,7,13,15,11,11,5,5 3)11,7,19,23,19,7,23,5 4)13,13,11,11,5,5,5,5",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    type=readline()
    if(type==1){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.33333333,	0,	0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,	0,
                  0,	0,	0,	0.577350269,	0.707106781,	0.40824829,	0,	0,
                  0,	0,	0,	0.577350269,	-0.707106781,	0.40824829,	0,	0,
                  0,	0,	0,	0.577350269,	0,	-0.816496581,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	1	),nrow=8,byrow=T)

    }
    if(type==2){
      B<-matrix(c(0.5,	0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,	0,
                  0,	0,	0,	0,	0.6,	0.8,	0,	0,
                  0,	0,	0,	0,	-0.8,	0.6,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	1	),nrow=8,byrow=T)

    }
    if(type==3){
      B<-matrix(c(0.5,	0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,	0,
                  0,	0,	0,	0,	0.333333333,	0,	-0.942809042,	0,
                  0,	0,	0,	0,	0.666666667,	0.707106781,	0.23570226,	0,
                  0,	0,	0,	0,	0.666666667,	-0.707106781,	0.23570226,	0,
                  0,	0,	0,	0,	0,	0,	0,	1
      ),nrow=8,byrow=T)


    }
    if(type==4){
      B<-matrix(c(0.866025404,	0.500000000,	0,	0,	0,	0,	0,	0,
                  -0.5,	0.866025404,	0,	0,	0,	0,	0,	0,
                  0,	0,	0.316227766,	0.632455532,	0,	0,	0,	0,
                  0,	0,	0.632455532,	-0.316227766,	0,	0,	0,	0,
                  0,	0,	0,	0,	1,	0,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	1),nrow=8,byrow=T)


    }
    x<-matrix(c(

      -1	,	0	,	1	,	0	,	1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	0	,	-1	,	1	,	0	,	1	,	-1	,	1	,
      0	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	1	,	1	,	0	,	1	,	1	,	1	,
      0	,	0	,	-1	,	1	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	1	,	-1	,	0	,	-1	,	1	,	1	,
      0	,	0	,	1	,	1	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	-1	,	1	,	0	,	-1	,	1	,	1	,
      0	,	0	,	1	,	-1	,	0	,	1	,	-1	,	1	,
      0	,	0	,	-1	,	1	,	0	,	1	,	1	,	-1	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	1	,	1	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	1	,	1	,	0	,	1	,	1	,	-1	,
      0	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	1	,	1	,	0	,	-1	,	1	,	1	,
      0	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	-1	,
      0	,	0	,	1	,	-1	,	0	,	1	,	1	,	1	,
      0	,	0	,	1	,	-1	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	1	,	1	,	0	,	1	,	-1	,	1	,
      0	,	0	,	1	,	-1	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	-1	,
      0	,	0	,	1	,	-1	,	0	,	1	,	1	,	-1	,
      0	,	0	,	-1	,	1	,	0	,	1	,	1	,	1	,
      0	,	0	,	-1	,	1	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	-1	,	-1	,	0	,	1	,	1	,	1	,
      0	,	0	,	1	,	1	,	0	,	-1	,	-1	,	-1	,
      0	,	0	,	-1	,	-1	,	0	,	1	,	1	,	-1	,
      0	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	-1	,
      0	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	1	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	1	,
      0	,	0	,	1	,	1	,	0	,	-1	,	1	,	-1	,
      0	,	-1	,	0	,	1	,	1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	-1	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	0	,	-1	,	-1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	1	,	1	,	1	,	1	,	0	,
      0	,	-1	,	0	,	1	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	-1	,	-1	,	1	,	1	,	0	,
      0	,	1	,	0	,	1	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	1	,	-1	,	1	,	1	,	0	,
      0	,	1	,	0	,	-1	,	1	,	-1	,	1	,	0	,
      0	,	-1	,	0	,	1	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	0	,	1	,	-1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	1	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	1	,	-1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	1	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	0	,	1	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	-1	,	1	,	1	,	1	,	0	,
      0	,	1	,	0	,	-1	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	0	,	1	,	1	,	-1	,	1	,	0	,
      0	,	1	,	0	,	-1	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	-1	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	1	,	1	,	1	,	1	,	0	,
      0	,	-1	,	0	,	1	,	-1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	1	,	1	,	1	,	0	,
      0	,	1	,	0	,	1	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	-1	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	0	,	-1	,	1	,	-1	,	1	,	0	,
      0	,	-1	,	0	,	-1	,	-1	,	1	,	1	,	0	,
      0	,	1	,	0	,	1	,	-1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	1	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,	1	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	1	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,	-1	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	1	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	1	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,	-1	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	1	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,	1	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,	1	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,	-1	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	1	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	1	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	1	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	1	,
      1	,	1	,	0	,	0	,	1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	1	,
      1	,	1	,	0	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	1	,	1	,
      1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	1	,
      -1	,	1	,	0	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	1	,
      1	,	1	,	0	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	0	,	1	,	0	,	1	,	1	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	0	,	1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	1	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	1	,	1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	1	,	1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	1	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	1	,	1	,	0	,	1	,	1	,	0	,	1	,
      0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	1	,
      0	,	1	,	1	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	1	,
      0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	1	,
      0	,	-1	,	1	,	0	,	1	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
      0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	1	,	1	,	0	,	1	,	1	,	0	,	-1	,
      0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	1	,	1	,	0	,	-1	,	1	,	0	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	0	,	1	,	1	,	0	,	1	,
      0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
      0	,	1	,	1	,	0	,	1	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	0	,	1	,	1	,	0	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	1	,	0	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	1	,
      0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	1	,
      0	,	1	,	1	,	0	,	-1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	1	,
      1	,	1	,	0	,	1	,	0	,	1	,	0	,	1	,
      -1	,	1	,	0	,	1	,	0	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	1	,
      1	,	1	,	0	,	1	,	0	,	-1	,	0	,	-1	,
      -1	,	1	,	0	,	-1	,	0	,	1	,	0	,	1	,
      1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	1	,	0	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	-1	,
      1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	1	,
      1	,	1	,	0	,	1	,	0	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	1	,
      1	,	1	,	0	,	-1	,	0	,	1	,	0	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	1	,	0	,	1	,	0	,	1	,
      1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	-1	,
      1	,	1	,	0	,	1	,	0	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	1	,	0	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	1	,	0	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	1	,	0	,	1	,
      1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	1	,
      1	,	1	,	0	,	-1	,	0	,	1	,	0	,	-1	,
      -1	,	1	,	1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	-1	,	-1	,	0	,	0	,	1	,	0	,
      -1	,	-1	,	-1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	1	,	1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	1	,	1	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	-1	,	1	,	0	,	0	,	1	,	0	,
      1	,	1	,	1	,	-1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	-1	,	1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	1	,	-1	,	0	,	0	,	1	,	0	,
      -1	,	1	,	1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	-1	,	1	,	0	,	0	,	-1	,	0	,
      1	,	1	,	-1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	1	,	1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	-1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	1	,	-1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	1	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	1	,	1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	-1	,	1	,	0	,	0	,	-1	,	0	,
      1	,	1	,	1	,	-1	,	0	,	0	,	1	,	0	,
      1	,	-1	,	1	,	-1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	1	,	1	,	1	,	0	,	0	,	1	,	0	,
      -1	,	1	,	-1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	1	,	1	,	0	,	0	,	1	,	0	,
      1	,	1	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	1	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	1	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,	0	,
      -1	,	-1	,	1	,	-1	,	0	,	0	,	1	,	0	,
      -1	,	-1	,	-1	,	1	,	0	,	0	,	1	,	0	,
      1	,	1	,	-1	,	1	,	0	,	0	,	-1	,	0	,
      0	,	1	,	0	,	0	,	0	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	0	,	0	,	1	,	-1	,	0	,
      0	,	-1	,	0	,	0	,	0	,	1	,	1	,	0	,
      0	,	-1	,	0	,	0	,	0	,	-1	,	1	,	0	,
      0	,	1	,	0	,	0	,	0	,	-1	,	-1	,	0	,
      0	,	1	,	0	,	0	,	0	,	-1	,	1	,	0	,
      0	,	1	,	0	,	0	,	0	,	1	,	1	,	0	,
      0	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	0	,
      0	,	0	,	1	,	0	,	1	,	0	,	-1	,	0	,
      0	,	0	,	-1	,	0	,	1	,	0	,	-1	,	0	,
      0	,	0	,	-1	,	0	,	1	,	0	,	1	,	0	,
      0	,	0	,	-1	,	0	,	-1	,	0	,	1	,	0	,
      0	,	0	,	1	,	0	,	-1	,	0	,	-1	,	0	,
      0	,	0	,	1	,	0	,	-1	,	0	,	1	,	0	,
      0	,	0	,	1	,	0	,	1	,	0	,	1	,	0	,
      0	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	0	,
      0	,	1	,	0	,	1	,	0	,	0	,	0	,	-1	,
      0	,	-1	,	0	,	1	,	0	,	0	,	0	,	-1	,
      0	,	-1	,	0	,	1	,	0	,	0	,	0	,	1	,
      0	,	-1	,	0	,	-1	,	0	,	0	,	0	,	1	,
      0	,	1	,	0	,	-1	,	0	,	0	,	0	,	-1	,
      0	,	1	,	0	,	-1	,	0	,	0	,	0	,	1	,
      0	,	1	,	0	,	1	,	0	,	0	,	0	,	1	,
      0	,	-1	,	0	,	-1	,	0	,	0	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	0	,	0	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	0	,	0	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	0	,	0	,	1	,	0	,	0	,	0	,
      1	,	-1	,	0	,	0	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	0	,	0	,	1	,	0	,	0	,	0	,
      1	,	1	,	0	,	0	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	0	,	0	,	-1	,	0	,	0	,	0	,
      1	,	0	,	1	,	0	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	1	,	0	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	1	,	0	,	0	,	0	,	0	,	1	,
      -1	,	0	,	-1	,	0	,	0	,	0	,	0	,	1	,
      1	,	0	,	-1	,	0	,	0	,	0	,	0	,	-1	,
      1	,	0	,	-1	,	0	,	0	,	0	,	0	,	1	,
      1	,	0	,	1	,	0	,	0	,	0	,	0	,	1	,
      -1	,	0	,	-1	,	0	,	0	,	0	,	0	,	-1	,
      0	,	0	,	1	,	1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	-1	,	1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	-1	,	1	,	0	,	1	,	0	,	0	,
      0	,	0	,	-1	,	-1	,	0	,	1	,	0	,	0	,
      0	,	0	,	1	,	-1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	1	,	-1	,	0	,	1	,	0	,	0	,
      0	,	0	,	1	,	1	,	0	,	1	,	0	,	0	,
      0	,	0	,	-1	,	-1	,	0	,	-1	,	0	,	0	,
      1	,	0	,	0	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	0	,	0	,	1	,	0	,	0	,	-1	,	0	,
      -1	,	0	,	0	,	1	,	0	,	0	,	1	,	0	,
      -1	,	0	,	0	,	-1	,	0	,	0	,	1	,	0	,
      1	,	0	,	0	,	-1	,	0	,	0	,	-1	,	0	,
      1	,	0	,	0	,	-1	,	0	,	0	,	1	,	0	,
      1	,	0	,	0	,	1	,	0	,	0	,	1	,	0	,
      -1	,	0	,	0	,	-1	,	0	,	0	,	-1	,	0	,
      0	,	0	,	0	,	0	,	1	,	1	,	0	,	-1	,
      0	,	0	,	0	,	0	,	-1	,	1	,	0	,	-1	,
      0	,	0	,	0	,	0	,	-1	,	1	,	0	,	1	,
      0	,	0	,	0	,	0	,	-1	,	-1	,	0	,	1	,
      0	,	0	,	0	,	0	,	1	,	-1	,	0	,	-1	,
      0	,	0	,	0	,	0	,	1	,	-1	,	0	,	1	,
      0	,	0	,	0	,	0	,	1	,	1	,	0	,	1	,
      0	,	0	,	0	,	0	,	-1	,	-1	,	0	,	-1	,
      2.828427	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
      -2.82843	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	2.828427	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	-2.82843	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	2.828427	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	-2.82843	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	2.828427	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	-2.82843	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	2.828427	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	-2.82843	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	2.828427	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	-2.82843	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	2.828427	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	-2.82843	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	0	,	2.828427	,
      0	,	0	,	0	,	0	,	0	,	0	,	0	,	-2.82843

    ),nrow=336,byrow=T)


  }
  #################
  if(v==9){
    print("1)9,7,11,15,11,11,5,5,5 2)9,7,19,23,13,13,9,9,5 3)19,7,23,7,7,19,5,5,5 4)19,19,19,13,13,5,5,5,5 5)13,13,11,11,5,5,5,5,5",quote=F)
    cat("\n")
    print("Please enter the serial number among the combinations:",quote=F)
    type=readline()
    if(type==1){
      B<-matrix(c(0.5, 0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,	0,	0,
                  0,	0,	0,	0,	0.6,	0.8,	0,	0,	0,
                  0,	0,	0,	0,	-0.8,	0.6,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)

    }
    if(type==2){
      B<-matrix(c(0.5, 0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	-0.707106781,	0.40824829,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	0,	-0.816496581,	0.288675135,	0,	0,	0,	0,	0,
                  0.5,	0,	0,	-0.866025404,	0,	0,	0,	0,	0,
                  0,	0,	0,	0,	0.866025404,	0.500000000,	0,	0,	0,
                  0,	0,	0,	0,	-0.5,	0.866025404,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	0.316227766,	0.632455532,	0,
                  0,	0,	0,	0,	0,	0,	0.632455532,	-0.316227766,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)


    }
    if(type==3){
      B<-matrix(c(0.333333333,	0,	-0.942809042,	0,	0,	0,	0,	0,	0,
                  0.666666667,	0.707106781,	0.23570226,	0,	0,	0,	0,	0,	0,
                  0.666666667,	-0.707106781,	0.23570226,	0,	0,	0,	0,	0,	0,
                  0,	0,	0,	0.577350269,	0.707106781,	0.40824829,	0,	0,	0,
                  0,	0,	0,	0.577350269,	-0.707106781,	0.40824829,	0,	0,	0,
                  0,	0,	0,	0.577350269,	0,	-0.816496581,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)


    }
    if(type==4){
      B<-matrix(c(0.333333333,	0.666666667,	-0.666666667,	0,	0,	0,	0,	0,	0,
                  -0.666666667,	0.666666667,	0.333333333,	0,	0,	0,	0,	0,	0,
                  0.666666667,	0.333333333,	0.666666667,	0,	0,	0,	0,	0,	0,
                  0,	0,	0,	0.866025404,	0.500000000,  0,	0,	0,	0,
                  0,	0,	0,	-0.5,	0.866025404,	0,	0,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)


    }
    if(type==5){
      B<-matrix(c(0.866025404,	0.500000000,	0,	0,	0,	0,	0,	0,	0,
                  -0.5,	0.866025404,	0,	0,	0,	0,	0,	0,	0,
                  0,	0,	0.316227766,	0.632455532,	0,	0,	0,	0,	0,
                  0,	0,	0.632455532,	-0.316227766	,0,	0,	0,	0,	0,
                  0,	0,	0,	0,	1,	0,	0,	0,	0,
                  0,	0,	0,	0,	0,	1,	0,	0,	0,
                  0,	0,	0,	0,	0,	0,	1,	0,	0,
                  0,	0,	0,	0,	0,	0,	0,	1,	0,
                  0,	0,	0,	0,	0,	0,	0,	0,	1	),nrow=9,byrow=T)


    }
    x<-matrix(c(
      1	,	1	,	-1	,	0	,	0	,	0	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	0	,	0	,	0	,
      -1	,	1	,	1	,	0	,	0	,	0	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	0	,	0	,
      1	,	-1	,	1	,	0	,	0	,	0	,	0	,	0	,	0	,
      1	,	1	,	1	,	0	,	0	,	0	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	1	,	1	,	-1	,	0	,	0	,	0	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      0	,	0	,	0	,	-1	,	1	,	1	,	0	,	0	,	0	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      0	,	0	,	0	,	1	,	-1	,	1	,	0	,	0	,	0	,
      0	,	0	,	0	,	1	,	1	,	1	,	0	,	0	,	0	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	1	,	1	,	-1	,
      0	,	0	,	0	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	0	,	0	,	0	,	-1	,	1	,	1	,
      0	,	0	,	0	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	0	,	0	,	0	,	1	,	-1	,	1	,
      0	,	0	,	0	,	0	,	0	,	0	,	1	,	1	,	1	,
      0	,	0	,	0	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      1	,	0	,	0	,	1	,	0	,	0	,	-1	,	0	,	0	,
      -1	,	0	,	0	,	1	,	0	,	0	,	-1	,	0	,	0	,
      -1	,	0	,	0	,	1	,	0	,	0	,	1	,	0	,	0	,
      -1	,	0	,	0	,	-1	,	0	,	0	,	1	,	0	,	0	,
      1	,	0	,	0	,	-1	,	0	,	0	,	-1	,	0	,	0	,
      1	,	0	,	0	,	-1	,	0	,	0	,	1	,	0	,	0	,
      1	,	0	,	0	,	1	,	0	,	0	,	1	,	0	,	0	,
      -1	,	0	,	0	,	-1	,	0	,	0	,	-1	,	0	,	0	,
      0	,	1	,	0	,	0	,	1	,	0	,	0	,	-1	,	0	,
      0	,	-1	,	0	,	0	,	1	,	0	,	0	,	-1	,	0	,
      0	,	-1	,	0	,	0	,	1	,	0	,	0	,	1	,	0	,
      0	,	-1	,	0	,	0	,	-1	,	0	,	0	,	1	,	0	,
      0	,	1	,	0	,	0	,	-1	,	0	,	0	,	-1	,	0	,
      0	,	1	,	0	,	0	,	-1	,	0	,	0	,	1	,	0	,
      0	,	1	,	0	,	0	,	1	,	0	,	0	,	1	,	0	,
      0	,	-1	,	0	,	0	,	-1	,	0	,	0	,	-1	,	0	,
      0	,	0	,	1	,	0	,	0	,	1	,	0	,	0	,	-1	,
      0	,	0	,	-1	,	0	,	0	,	1	,	0	,	0	,	-1	,
      0	,	0	,	-1	,	0	,	0	,	1	,	0	,	0	,	1	,
      0	,	0	,	-1	,	0	,	0	,	-1	,	0	,	0	,	1	,
      0	,	0	,	1	,	0	,	0	,	-1	,	0	,	0	,	-1	,
      0	,	0	,	1	,	0	,	0	,	-1	,	0	,	0	,	1	,
      0	,	0	,	1	,	0	,	0	,	1	,	0	,	0	,	1	,
      0	,	0	,	-1	,	0	,	0	,	-1	,	0	,	0	,	-1	,
      1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	0	,
      -1	,	0	,	0	,	0	,	0	,	1	,	0	,	-1	,	0	,
      -1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	0	,
      -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	0	,
      1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	0	,
      1	,	0	,	0	,	0	,	0	,	-1	,	0	,	1	,	0	,
      1	,	0	,	0	,	0	,	0	,	1	,	0	,	1	,	0	,
      -1	,	0	,	0	,	0	,	0	,	-1	,	0	,	-1	,	0	,
      0	,	1	,	0	,	1	,	0	,	0	,	0	,	0	,	-1	,
      0	,	-1	,	0	,	1	,	0	,	0	,	0	,	0	,	-1	,
      0	,	-1	,	0	,	1	,	0	,	0	,	0	,	0	,	1	,
      0	,	-1	,	0	,	-1	,	0	,	0	,	0	,	0	,	1	,
      0	,	1	,	0	,	-1	,	0	,	0	,	0	,	0	,	-1	,
      0	,	1	,	0	,	-1	,	0	,	0	,	0	,	0	,	1	,
      0	,	1	,	0	,	1	,	0	,	0	,	0	,	0	,	1	,
      0	,	-1	,	0	,	-1	,	0	,	0	,	0	,	0	,	-1	,
      0	,	0	,	1	,	0	,	1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	-1	,	0	,	1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	-1	,	0	,	1	,	0	,	1	,	0	,	0	,
      0	,	0	,	-1	,	0	,	-1	,	0	,	1	,	0	,	0	,
      0	,	0	,	1	,	0	,	-1	,	0	,	-1	,	0	,	0	,
      0	,	0	,	1	,	0	,	-1	,	0	,	1	,	0	,	0	,
      0	,	0	,	1	,	0	,	1	,	0	,	1	,	0	,	0	,
      0	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	0	,
      1	,	0	,	0	,	0	,	1	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	0	,	0	,	1	,	0	,	0	,	0	,	-1	,
      -1	,	0	,	0	,	0	,	1	,	0	,	0	,	0	,	1	,
      -1	,	0	,	0	,	0	,	-1	,	0	,	0	,	0	,	1	,
      1	,	0	,	0	,	0	,	-1	,	0	,	0	,	0	,	-1	,
      1	,	0	,	0	,	0	,	-1	,	0	,	0	,	0	,	1	,
      1	,	0	,	0	,	0	,	1	,	0	,	0	,	0	,	1	,
      -1	,	0	,	0	,	0	,	-1	,	0	,	0	,	0	,	-1	,
      0	,	1	,	0	,	0	,	0	,	1	,	-1	,	0	,	0	,
      0	,	-1	,	0	,	0	,	0	,	1	,	-1	,	0	,	0	,
      0	,	-1	,	0	,	0	,	0	,	1	,	1	,	0	,	0	,
      0	,	-1	,	0	,	0	,	0	,	-1	,	1	,	0	,	0	,
      0	,	1	,	0	,	0	,	0	,	-1	,	-1	,	0	,	0	,
      0	,	1	,	0	,	0	,	0	,	-1	,	1	,	0	,	0	,
      0	,	1	,	0	,	0	,	0	,	1	,	1	,	0	,	0	,
      0	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	0	,	0	,
      0	,	0	,	1	,	1	,	0	,	0	,	0	,	-1	,	0	,
      0	,	0	,	-1	,	1	,	0	,	0	,	0	,	-1	,	0	,
      0	,	0	,	-1	,	1	,	0	,	0	,	0	,	1	,	0	,
      0	,	0	,	-1	,	-1	,	0	,	0	,	0	,	1	,	0	,
      0	,	0	,	1	,	-1	,	0	,	0	,	0	,	-1	,	0	,
      0	,	0	,	1	,	-1	,	0	,	0	,	0	,	1	,	0	,
      0	,	0	,	1	,	1	,	0	,	0	,	0	,	1	,	0	,
      0	,	0	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	0	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	1	,	1	,	1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	1	,	1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	1	,	1	,	1	,
      0	,	0	,	0	,	1	,	1	,	1	,	-1	,	-1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	-1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	-1	,	-1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	1	,	-1	,	-1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	1	,	-1	,	1	,	1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	-1	,	1	,	1	,	-1	,
      0	,	0	,	0	,	1	,	1	,	-1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	-1	,	1	,	-1	,	-1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	-1	,	-1	,	1	,	1	,
      0	,	0	,	0	,	-1	,	1	,	1	,	-1	,	-1	,	1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      1	,	1	,	1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	1	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	1	,	1	,	1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	1	,	1	,
      1	,	1	,	1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      1	,	1	,	1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      1	,	1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	1	,	1	,	1	,
      1	,	1	,	1	,	0	,	0	,	0	,	1	,	1	,	1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      1	,	1	,	1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	1	,	1	,	1	,
      1	,	1	,	1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	1	,	1	,	1	,
      1	,	1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	-1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	-1	,
      1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	1	,	-1	,	-1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      1	,	-1	,	1	,	0	,	0	,	0	,	1	,	-1	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	1	,	1	,	1	,
      -1	,	-1	,	-1	,	0	,	0	,	0	,	1	,	1	,	-1	,
      1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	-1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	1	,	-1	,	0	,	0	,	0	,	-1	,	1	,	1	,
      -1	,	1	,	1	,	0	,	0	,	0	,	-1	,	-1	,	1	,
      -1	,	-1	,	1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      1	,	1	,	1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	1	,	1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	1	,	1	,	1	,	0	,	0	,	0	,
      1	,	1	,	1	,	-1	,	-1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	-1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	-1	,	-1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	1	,	-1	,	-1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      1	,	-1	,	1	,	1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	-1	,	1	,	1	,	-1	,	0	,	0	,	0	,
      1	,	1	,	-1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	-1	,	1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	-1	,	-1	,	1	,	1	,	0	,	0	,	0	,
      -1	,	1	,	1	,	-1	,	-1	,	1	,	0	,	0	,	0	,
      0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	1	,
      0	,	1	,	1	,	0	,	1	,	1	,	0	,	1	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,
      0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,
      0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,
      0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	1	,
      0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,
      0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	1	,	-1	,	0	,	1	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	1	,	0	,	-1	,	-1	,
      0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	1	,
      0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	1	,
      0	,	1	,	-1	,	0	,	1	,	1	,	0	,	1	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	1	,
      0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	1	,
      0	,	-1	,	1	,	0	,	1	,	1	,	0	,	1	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	1	,	0	,	-1	,	1	,
      0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,
      0	,	1	,	1	,	0	,	1	,	-1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	-1	,	1	,	0	,	1	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	-1	,
      0	,	1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,
      0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	1	,
      0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,
      0	,	1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	1	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	1	,	1	,	0	,	1	,	1	,
      0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	1	,	-1	,
      0	,	1	,	1	,	0	,	1	,	1	,	0	,	-1	,	-1	,
      0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	1	,	-1	,
      0	,	1	,	-1	,	0	,	1	,	1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	1	,	1	,	0	,	-1	,	1	,
      0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	-1	,
      0	,	1	,	1	,	0	,	-1	,	1	,	0	,	1	,	1	,
      0	,	1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,
      0	,	1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,
      0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,
      0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,
      0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	1	,	1	,
      0	,	1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	1	,	1	,
      0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	-1	,
      0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	1	,
      0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	1	,
      -1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	1	,
      1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
      1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
      -1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
      1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	1	,
      -1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,	1	,
      1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
      -1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
      -1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	1	,
      1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
      -1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,	-1	,
      1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	1	,
      -1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	1	,
      1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	1	,
      1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	1	,
      -1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,	-1	,
      -1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,	1	,
      1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	1	,
      1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
      1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,	1	,
      1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	-1	,
      1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
      1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	1	,
      1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
      1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,	-1	,
      -1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,	1	,
      1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,	1	,
      -1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,	-1	,
      1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,	-1	,
      -1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,	-1	,
      1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,	1	,
      1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,	1	,
      1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,	-1	,
      1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,	1	,
      1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,
      1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,
      1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
      -1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,
      -1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,	1	,
      1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,	1	,
      -1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,	-1	,
      1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,	1	,
      -1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,
      1	,	1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,
      1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,
      1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,
      -1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,
      -1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,
      1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,
      -1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,
      1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,
      -1	,	-1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,
      -1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,
      -1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,
      1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,
      -1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,
      -1	,	1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,
      1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,
      -1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,
      -1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,
      1	,	-1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,
      1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,
      -1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,
      -1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,
      1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,
      -1	,	1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,
      -1	,	1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,
      1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,
      1	,	1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,
      -1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,
      1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,
      -1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,
      1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	-1	,	0	,
      1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,
      1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,
      1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,
      -1	,	1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,
      -1	,	1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,
      1	,	1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,
      -1	,	-1	,	0	,	1	,	1	,	0	,	1	,	-1	,	0	,
      1	,	-1	,	0	,	1	,	1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,
      1	,	-1	,	0	,	1	,	-1	,	0	,	1	,	-1	,	0	,
      1	,	1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,
      1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	-1	,	0	,
      1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	-1	,	0	,
      -1	,	-1	,	0	,	-1	,	-1	,	0	,	1	,	-1	,	0	,
      1	,	-1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,
      -1	,	-1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	1	,	0	,	-1	,	-1	,	0	,
      -1	,	1	,	0	,	1	,	-1	,	0	,	1	,	1	,	0	,
      1	,	-1	,	0	,	1	,	1	,	0	,	-1	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	1	,	0	,	1	,	1	,	0	,
      -1	,	-1	,	0	,	-1	,	1	,	0	,	1	,	-1	,	0	,
      1	,	1	,	0	,	-1	,	-1	,	0	,	-1	,	1	,	0	,
      -1	,	-1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,
      -1	,	1	,	0	,	-1	,	-1	,	0	,	1	,	1	,	0	,
      -1	,	1	,	0	,	1	,	-1	,	0	,	-1	,	1	,	0	,
      0	,	-1	,	-1	,	1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	1	,	1	,	1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	-1	,	1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	1	,	-1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	1	,	-1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	-1	,	1	,	1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	-1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	1	,	1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	1	,	-1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	1	,	1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	-1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	-1	,	1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	1	,	-1	,	1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	-1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	-1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	1	,	1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	1	,	1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	-1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	1	,	1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	-1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	-1	,	1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	1	,	1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	-1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	1	,	-1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	1	,	-1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	-1	,	1	,	1	,	1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	1	,	1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	1	,	1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	1	,	1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	-1	,	1	,	1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	1	,	-1	,	1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	1	,	-1	,	1	,	0	,	1	,	0	,	1	,
      0	,	1	,	1	,	1	,	-1	,	0	,	-1	,	0	,	-1	,
      0	,	1	,	-1	,	1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	-1	,	-1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	-1	,	-1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	-1	,	-1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	1	,	0	,	-1	,	0	,	-1	,
      0	,	-1	,	1	,	1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	1	,	-1	,	1	,	1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	-1	,	-1	,	1	,	0	,	1	,	0	,	-1	,
      0	,	1	,	1	,	-1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	-1	,	1	,	-1	,	0	,	-1	,	0	,	1	,
      0	,	-1	,	1	,	-1	,	-1	,	0	,	1	,	0	,	1	,
      0	,	-1	,	1	,	1	,	-1	,	0	,	-1	,	0	,	1	,
      -1	,	0	,	-1	,	0	,	1	,	1	,	-1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	1	,	1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	-1	,	1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	-1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	-1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	-1	,	1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	1	,	1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	-1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	1	,	-1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	1	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	1	,	1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	1	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	1	,	1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	1	,	-1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	1	,	1	,	1	,	0	,
      1	,	0	,	1	,	0	,	1	,	-1	,	-1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	-1	,	1	,	-1	,	0	,
      1	,	0	,	-1	,	0	,	-1	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	1	,	-1	,	-1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	-1	,	1	,	1	,	0	,
      1	,	0	,	-1	,	0	,	1	,	1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	1	,	1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	-1	,	1	,	1	,	-1	,	0	,
      1	,	0	,	1	,	0	,	-1	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	0	,	1	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	-1	,	-1	,	1	,	1	,	0	,
      -1	,	0	,	1	,	0	,	1	,	-1	,	-1	,	1	,	0	,
      -1	,	-1	,	0	,	1	,	0	,	1	,	0	,	-1	,	1	,
      1	,	1	,	0	,	1	,	0	,	1	,	0	,	1	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	1	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	-1	,
      -1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	1	,
      -1	,	-1	,	0	,	1	,	0	,	1	,	0	,	1	,	1	,
      1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	1	,	1	,
      1	,	1	,	0	,	1	,	0	,	-1	,	0	,	1	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	1	,
      -1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	1	,	1	,
      1	,	-1	,	0	,	1	,	0	,	1	,	0	,	1	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	1	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	1	,	1	,
      1	,	1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	1	,	0	,	1	,	0	,	-1	,	0	,	1	,	1	,
      1	,	1	,	0	,	-1	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	-1	,
      1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	1	,	0	,	1	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	1	,	0	,	1	,	1	,
      1	,	1	,	0	,	1	,	0	,	1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	1	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	1	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	1	,	0	,	1	,	0	,	1	,	-1	,
      1	,	-1	,	0	,	1	,	0	,	1	,	0	,	1	,	1	,
      1	,	1	,	0	,	1	,	0	,	1	,	0	,	-1	,	1	,
      1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	-1	,	0	,	1	,	0	,	1	,	1	,
      1	,	1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	-1	,
      1	,	-1	,	0	,	1	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	-1	,
      1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	-1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	1	,	0	,	-1	,	-1	,
      -1	,	1	,	0	,	1	,	0	,	-1	,	0	,	1	,	1	,
      1	,	-1	,	0	,	1	,	0	,	1	,	0	,	-1	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	1	,	0	,	1	,	1	,
      -1	,	-1	,	0	,	-1	,	0	,	1	,	0	,	1	,	-1	,
      1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	1	,
      -1	,	1	,	0	,	-1	,	0	,	-1	,	0	,	1	,	1	,
      -1	,	1	,	0	,	1	,	0	,	-1	,	0	,	-1	,	1	,
      0	,	-1	,	-1	,	1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	1	,	1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	1	,	1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	1	,	1	,	1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	1	,	1	,	1	,	0	,
      0	,	1	,	1	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	1	,	1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	1	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	1	,	1	,	1	,	0	,
      0	,	1	,	1	,	1	,	0	,	1	,	1	,	1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	1	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	1	,	1	,	1	,	0	,
      0	,	1	,	1	,	1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	1	,	1	,	1	,	0	,
      0	,	1	,	1	,	1	,	0	,	-1	,	-1	,	-1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	-1	,	1	,	-1	,	0	,
      0	,	1	,	-1	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	1	,	-1	,	-1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	1	,	-1	,	1	,	0	,	1	,	-1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	1	,	1	,	1	,	0	,
      0	,	-1	,	-1	,	-1	,	0	,	1	,	1	,	-1	,	0	,
      0	,	1	,	1	,	-1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	-1	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      0	,	-1	,	1	,	-1	,	0	,	-1	,	1	,	1	,	0	,
      0	,	-1	,	1	,	1	,	0	,	-1	,	-1	,	1	,	0	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	1	,	1	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	1	,	-1	,
      -1	,	0	,	1	,	1	,	1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	-1	,	1	,	1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	1	,	1	,	0	,	0	,	-1	,	1	,
      1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	1	,	-1	,	1	,	0	,	0	,	1	,	1	,
      1	,	0	,	1	,	1	,	-1	,	0	,	0	,	-1	,	-1	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	-1	,	-1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	-1	,	-1	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	1	,	1	,
      1	,	0	,	-1	,	1	,	1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	1	,	-1	,	1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	-1	,	-1	,	1	,	0	,	0	,	1	,	-1	,
      1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	-1	,	1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	0	,	1	,	-1	,	-1	,	0	,	0	,	1	,	1	,
      -1	,	0	,	1	,	1	,	-1	,	0	,	0	,	-1	,	1	,
      -1	,	-1	,	0	,	0	,	1	,	1	,	-1	,	0	,	1	,
      1	,	1	,	0	,	0	,	1	,	1	,	1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	1	,	1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	1	,	1	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	1	,	1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	1	,	-1	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	1	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	1	,	-1	,	1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	1	,	1	,	1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	1	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	1	,	1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	1	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	1	,	-1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	1	,	-1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	-1	,	1	,	1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	-1	,	1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	1	,	1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	1	,	1	,	1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	1	,	-1	,	1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	1	,	1	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	1	,	1	,	1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	1	,	1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	1	,	1	,	-1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	1	,	-1	,	1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	1	,	1	,	0	,	1	,
      1	,	1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	1	,	1	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	-1	,
      1	,	-1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	-1	,
      -1	,	-1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	1	,	-1	,	0	,	-1	,
      -1	,	1	,	0	,	0	,	1	,	-1	,	1	,	0	,	1	,
      1	,	-1	,	0	,	0	,	1	,	1	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	1	,	1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	-1	,	1	,	1	,	0	,	-1	,
      1	,	1	,	0	,	0	,	-1	,	-1	,	-1	,	0	,	1	,
      -1	,	-1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	-1	,	-1	,	1	,	0	,	1	,
      -1	,	1	,	0	,	0	,	1	,	-1	,	-1	,	0	,	1	,
      3	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
      -3	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	3	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	-3	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	3	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	-3	,	0	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	3	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	-3	,	0	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	3	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	-3	,	0	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	3	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	-3	,	0	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	3	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	-3	,	0	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	0	,	3	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	0	,	-3	,	0	,
      0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	3	,
      0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,	-3
    ),nrow=882,byrow=T)

  }

  ##########################
  z=x%*%B
  message("Asymmetric Third Order Rotatable Design")
  cat("\n")
  z=round(z,digits = 5)
  z=format(z,nsmall=5)
  z=noquote(z)
  return(z)
}

