% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/creating.diploid.R
\name{creating.diploid}
\alias{creating.diploid}
\title{Generation of the starting population}
\usage{
creating.diploid(
  population = NULL,
  nsnp = 0,
  nindi = 0,
  nqtl = 0,
  name.cohort = NULL,
  generation = 1,
  founder.pool = 1,
  one.sex.mode = FALSE,
  database.sex.mode = FALSE,
  sex.s = "fixed",
  sex.quota = 0.5,
  class = 0L,
  verbose = TRUE,
  map = NULL,
  chr.nr = NULL,
  chromosome.length = NULL,
  bp = NULL,
  snps.equidistant = NULL,
  template.chip = NULL,
  snp.position = NULL,
  change.order = TRUE,
  add.chromosome = FALSE,
  bpcm.conversion = 0,
  snp.name = NULL,
  hom0 = NULL,
  hom1 = NULL,
  dataset = NULL,
  freq = "beta",
  beta.shape1 = 1,
  beta.shape2 = 1,
  share.genotyped = 0,
  genotyped.s = NULL,
  vcf = NULL,
  vcf.maxsnp = Inf,
  vcf.maxindi = Inf,
  vcf.chromosomes = NULL,
  vcf.VA = TRUE,
  trait.name = NULL,
  mean.target = NULL,
  var.target = NULL,
  qtl.position.shared = FALSE,
  trait.cor = NULL,
  trait.cor.include = NULL,
  n.additive = 0,
  n.equal.additive = 0,
  n.dominant = 0,
  n.equal.dominant = 0,
  n.overdominant = 0,
  n.equal.overdominant = 0,
  n.qualitative = 0,
  n.quantitative = 0,
  effect.distribution = "gauss",
  gamma.shape1 = 1,
  gamma.shape2 = 1,
  real.bv.add = NULL,
  real.bv.mult = NULL,
  real.bv.dice = NULL,
  new.residual.correlation = NULL,
  new.breeding.correlation = NULL,
  litter.effect.covariance = NULL,
  pen.effect.covariance = NULL,
  is.maternal = NULL,
  is.paternal = NULL,
  fixed.effects = NULL,
  trait.pool = 0,
  gxe.correlation = NULL,
  n.locations = NULL,
  gxe.max = 0.85,
  gxe.min = 0.7,
  location.name = NULL,
  gxe.combine = TRUE,
  n.traits = 0,
  base.bv = NULL,
  dominant.only.positive = FALSE,
  exclude.snps = NULL,
  var.additive.l = NULL,
  var.dominant.l = NULL,
  var.overdominant.l = NULL,
  var.qualitative.l = NULL,
  var.quantitative.l = NULL,
  effect.size.equal.add = 1,
  effect.size.equal.dom = 1,
  effect.size.equal.over = 1,
  polygenic.variance = 100,
  bve.mult.factor = NULL,
  bve.poly.factor = NULL,
  set.zero = FALSE,
  bv.standard = FALSE,
  replace.real.bv = FALSE,
  bv.ignore.traits = NULL,
  remove.invalid.qtl = TRUE,
  randomSeed = NULL,
  add.architecture = NULL,
  time.point = 0,
  creating.type = 0,
  size.scaling = 1,
  progress.bar = TRUE,
  miraculix = TRUE,
  miraculix.dataset = TRUE,
  add.chromosome.ends = TRUE,
  use.recalculate.manual = FALSE,
  store.comp.times = TRUE,
  skip.rest = FALSE,
  enter.bv = TRUE,
  internal = FALSE,
  internal.geno = TRUE,
  internal.dataset = NULL,
  nbits = 30,
  bit.storing = FALSE,
  new.phenotype.correlation = NULL,
  length.before = 5,
  length.behind = 5,
  position.scaling = FALSE,
  shuffle.cor = NULL,
  shuffle.traits = NULL,
  bv.total = 0
)
}
\arguments{
\item{population}{Population list}

\item{nsnp}{Number of markers to generate (Split equally across chromosomes (chr.nr) unless vector is used)}

\item{nindi}{Number of individuals to generate (you can also provide number males / females in a vector)}

\item{nqtl}{Number of QTLs to generate (this will be a subset of the generated SNPs; default: NULL; all SNPs are potential QTLs)}

\item{name.cohort}{Name of the newly added cohort}

\item{generation}{Generation to which newly individuals are added (default: 1)}

\item{founder.pool}{Founder pool an individual is assign to (default: 1)}

\item{one.sex.mode}{Activating this will ignore all sex specific parameters and handle each individual as part of the first sex (default: FALSE)}

\item{database.sex.mode}{Set TRUE to automatically remove females in selection.m and remove males in selection.f}

\item{sex.s}{Specify which newly added individuals are male (1) or female (2)}

\item{sex.quota}{Share of newly added female individuals (deterministic if sex.s="fixed", alt: sex.s="random")}

\item{class}{Migration level of the newly added individuals (default: 0)}

\item{verbose}{Set to FALSE to not display any prints}

\item{map}{map-file that contains up to 5 colums (chromosome, SNP-id, M-position, Bp-position, allele freq - Everything not provides it set to NA). A map can be imported via MoBPSmaps::ensembl.map()}

\item{chr.nr}{Number of chromosomes (SNPs are equally split) or vector containing the associated chromosome for each marker}

\item{chromosome.length}{Length of the newly added chromosome in Morgan; can be a vector when generating multiple chromosomes (default: 5)}

\item{bp}{Vector containing the physical position (bp) for each marker (default: 1,2,3...)}

\item{snps.equidistant}{Use equidistant markers (computationally faster! ; default: TRUE)}

\item{template.chip}{Import genetic map and chip from a species ("cattle", "chicken", "pig")}

\item{snp.position}{Location of each marker on the genetic map}

\item{change.order}{Markers are automatically sorted according to their snp.position unless this is set to FALSE (default: TRUE)}

\item{add.chromosome}{If TRUE add an additional chromosome to the population}

\item{bpcm.conversion}{Convert physical position (bp) into a cM position (default: 0 - not done)}

\item{snp.name}{Vector containing the name of each marker (default ChrXSNPY - XY chosen accordingly)}

\item{hom0}{Vector containing the first allelic variant in each marker (default: 0)}

\item{hom1}{Vector containing the second allelic variant in each marker (default: 1)}

\item{dataset}{SNP dataset, use "random", "allhetero" "all0" when generating a dataset via nsnp,nindi}

\item{freq}{frequency of allele 1 when randomly generating a dataset (default: "beta" with parameters beta.shape1, beta.shape2; Use "same" when generating additional individuals and using the same allele frequencies)}

\item{beta.shape1}{First parameter of the beta distribution for simulating allele frequencies}

\item{beta.shape2}{Second parameter of the beta distribution for simulating allele frequencies}

\item{share.genotyped}{Share of individuals genotyped in the founders}

\item{genotyped.s}{Specify with newly added individuals are genotyped (1) or not (0)}

\item{vcf}{Path to a vcf-file used as input genotypes (correct haplotype phase is assumed!)}

\item{vcf.maxsnp}{Maximum number of SNPs to include in the genotype file (default: Inf)}

\item{vcf.maxindi}{Maximum number of individuals to include in the genotype file (default: Inf)}

\item{vcf.chromosomes}{Vector of chromosomes to import from vcf. Use on bgziped and tabixed vcf only. (default: NULL - all chromosomes)}

\item{vcf.VA}{Use the VariantAnnotation package to load in a vcf file when available (default: TRUE)}

\item{trait.name}{Name of the traits generated}

\item{mean.target}{Target mean for each trait}

\item{var.target}{Target variance for each trait}

\item{qtl.position.shared}{Set to TRUE to put QTL effects on the same markers for different traits}

\item{trait.cor}{Target correlation between QTL-based traits (underlying true genomic values)}

\item{trait.cor.include}{Vector of traits to be included in the modelling of correlated traits (default: all - needs to match with trait.cor)}

\item{n.additive}{Number of additive QTL with effect size drawn from a gaussian distribution}

\item{n.equal.additive}{Number of additive QTL with equal effect size (effect.size)}

\item{n.dominant}{Number of dominant QTL with effect size drawn from a gaussian distribution}

\item{n.equal.dominant}{Number of dominant QTL with equal effect size}

\item{n.overdominant}{Number of overdominant QTL with effect size drawn from absolute value of a gaussian distribution}

\item{n.equal.overdominant}{Number of overdominant QTL with equal effect size}

\item{n.qualitative}{Number of qualitative epistatic QTL}

\item{n.quantitative}{Number of quantitative epistatic QTL}

\item{effect.distribution}{Set to "gamma" for gamma distribution effects with gamma.shape1, gamma.shape2 instead of gaussian (default: "gauss")}

\item{gamma.shape1}{Default: 1}

\item{gamma.shape2}{Default: 1}

\item{real.bv.add}{Single Marker effects (list for each trait with columns for: SNP Nr, Chr Nr, Effect 00, Effect 01, Effect 11, Position (optional), Founder pool genotype (optional), Founder pool origin (optional))}

\item{real.bv.mult}{Two Marker effects}

\item{real.bv.dice}{Multi-marker effects}

\item{new.residual.correlation}{Correlation of the simulated enviromental variance}

\item{new.breeding.correlation}{Correlation of the simulated genetic variance (child share! heritage is not influenced!}

\item{litter.effect.covariance}{Covariance matrix of the litter effect (default: no effects)}

\item{pen.effect.covariance}{Covariance matrix of the pen effect (default: no effects)}

\item{is.maternal}{Vector coding if a trait is caused by a maternal effect (Default: FALSE)}

\item{is.paternal}{Vector coding if a trait is caused by a paternal effect (Default: FALSE)}

\item{fixed.effects}{Matrix containing fixed effects (p x k -matrix with p being the number of traits and k being number of fixed effects; default: not fixed effects (NULL))}

\item{trait.pool}{Vector providing information for which pools QTLs of which trait are activ (default: 0 - all pools)}

\item{gxe.correlation}{Correlation matrix between locations / environments (default: only one location, sampled from gxe.max / gxe.min)}

\item{n.locations}{Number of locations / environments to consider for the GxE model}

\item{gxe.max}{Maximum correlation between locations / environments when generating correlation matrix via sampling (default: 0.85)}

\item{gxe.min}{Minimum correlation between locations / environments when generating correlation matrix via sampling (default: 0.70)}

\item{location.name}{Same of the different locations / environments used}

\item{gxe.combine}{Set to FALSE to not view the same trait from different locations / environments as the sample trait in the prediction model (default: TRUE)}

\item{n.traits}{Number of traits (If more than traits via real.bv.X use traits with no directly underlying QTL)}

\item{base.bv}{Intercept of underlying true genomic values (excluding all QTL effects, default: 100)}

\item{dominant.only.positive}{Set to TRUE to always assign the heterozygous variant with the higher of the two homozygous effects (e.g. hybrid breeding); default: FALSE}

\item{exclude.snps}{Vector contain markers on which no QTL effects are placed}

\item{var.additive.l}{Variance of additive QTL}

\item{var.dominant.l}{Variance of dominante QTL}

\item{var.overdominant.l}{Variance of overdominante QTL}

\item{var.qualitative.l}{Variance of qualitative epistatic QTL}

\item{var.quantitative.l}{Variance of quantitative epistatic QTL}

\item{effect.size.equal.add}{Effect size of the QTLs in n.equal.additive}

\item{effect.size.equal.dom}{Effect size of the QTLs in n.equal.dominant}

\item{effect.size.equal.over}{Effect size of the QTLs in n.equal.overdominant}

\item{polygenic.variance}{Genetic variance of traits with no underlying QTL}

\item{bve.mult.factor}{Multiplicate trait value times this}

\item{bve.poly.factor}{Potency trait value over this}

\item{set.zero}{Set to TRUE to have no effect on the 0 genotype (or 00 for QTLs with 2 underlying SNPs)}

\item{bv.standard}{Set TRUE to standardize trait mean and variance via bv.standardization() - automatically set to TRUE when mean/var.target are used}

\item{replace.real.bv}{If TRUE delete the simulated traits added before}

\item{bv.ignore.traits}{Vector of traits to ignore in the calculation of the genomic value (default: NULL; Only recommended for high number of traits and experienced users!)}

\item{remove.invalid.qtl}{Set to FALSE to deactive the automatic removal of QTLs on markers that do not exist}

\item{randomSeed}{Set random seed of the process}

\item{add.architecture}{Add genetic architecture (marker positions)}

\item{time.point}{Time point at which the new individuals are generated}

\item{creating.type}{Technique to generate new individuals (usage in web-based application)}

\item{size.scaling}{Set to value to scale all input for breeding.size / selection.size (This will not work for all breeding programs / less general than json.simulation)}

\item{progress.bar}{Set to FALSE to not use progress bars in any application of breeding.diploid() downstream (Keep log-files lean!)}

\item{miraculix}{If TRUE use miraculix package for data storage, computations and dataset generation}

\item{miraculix.dataset}{Set FALSE to deactivate miraculix package for dataset generation}

\item{add.chromosome.ends}{Add chromosome ends as recombination points}

\item{use.recalculate.manual}{Set to TRUE to use recalculate.manual to calculate genomic values (all individuals and traits jointly, default: FALSE)}

\item{store.comp.times}{Set to FALSE to not store computing times needed to execute creating.diploid in $info$comp.times.creating}

\item{skip.rest}{Internal variable needed when adding multiple chromosomes jointly}

\item{enter.bv}{Internal parameter}

\item{internal}{Do not touch!}

\item{internal.geno}{Do not touch!}

\item{internal.dataset}{Do not touch!}

\item{nbits}{Bits available in MoBPS-bit-storing}

\item{bit.storing}{Set to TRUE if the MoBPS (not-miraculix! bit-storing is used)}

\item{new.phenotype.correlation}{(OLD! - use new.residual.correlation) Correlation of the simulated enviromental variance}

\item{length.before}{Length before the first SNP of the dataset (default: 5)}

\item{length.behind}{Length after the last SNP of the dataset (default: 5)}

\item{position.scaling}{Manual scaling of snp.position}

\item{shuffle.cor}{OLD! Use trait.cor - Target Correlation between traits}

\item{shuffle.traits}{OLD! Use trait.cor.include - Vector of traits to be included for modelling of correlated traits (default: all - needs to match with shuffle.cor)}

\item{bv.total}{OLD! Use n.traits instead. Number of traits (If more than traits via real.bv.X use traits with no directly underlying QTL)}
}
\value{
Population-list
}
\description{
Generation of the starting population
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100)
}
