% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.index.R
\name{get.index}
\alias{get.index}
\title{Putting together indices for GxE / multi trait}
\usage{
get.index(
  population,
  traits = NULL,
  locations = NULL,
  trait.weights = NULL,
  location.weights = NULL
)
}
\arguments{
\item{population}{Population list}

\item{traits}{Which traits to include in the index (all weight with factor 1)}

\item{locations}{Which locations to include in the index (all weight weight factor 1)}

\item{trait.weights}{Vector with a weight per trait}

\item{location.weights}{Vector weight a weight per location}
}
\value{
Index
}
\description{
Function to put together indices for GxE / multi trait
}
\examples{
population = creating.diploid(nsnp =1000, nindi = 100)
population = creating.trait(population, n.additive = c(10,10), n.location=3, replace.traits = TRUE)
get.index(population, trait.weights = c(1,2), location.weights = c(1,2,3))
}
