% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSaveData.R
\name{getSavedata_Bparams}
\alias{getSavedata_Bparams}
\title{Load the draws from the Bayesian model posterior distribution (SAVEDATA BPARAMETERS) command into an R data.frame}
\usage{
getSavedata_Bparams(outfile, discardBurnin = TRUE)
}
\arguments{
\item{outfile}{Required. The name of the Mplus output file to read. Can be an absolute or relative path.
If \code{outfile} is a relative path or just the filename, then it is assumed that the file resides in
the working directory \code{getwd()}.}

\item{discardBurnin}{Optional. Whether to discard the burn-in phase of each MCMC chain (i.e., the first half).}
}
\value{
A \code{list} containing the draws from the MCMC chains for a Bayesian model that uses the
SAVEDATA BPARAMETERS command. Each list element corresponds to a single MCMC chain, as specified by
the ANALYSIS: CHAINS syntax in \code{Mplus}. If discardBurnin is \code{FALSE}, then a superordinate list is
provided that divides output in terms of burn-in versus valid draw halves of the MCMC chains. For documentation
of how \code{Mplus} implements chain convergence checks and MCMC draws, see here: \url{http://www.statmodel.com/download/Bayes3.pdf}.
}
\description{
This function reads a the BPARAMETERS output file from the Mplus SAVEDATA BPARAMETERS command
and returns an R \code{data.frame} object.
}
\note{
Note that the \code{outfile} parameter should refer to the Mplus output file (.out extension), not the
actual dataset generated by SAVEDATA. This function reads information about the dataset from the .out file
and loads the dataset accordingly.
}
\examples{
\dontrun{
  fileInfo <- getSavedata_Data("C:/Program Files/Mplus/Test Output.out")
}
}
\references{
\url{http://www.statmodel.com/download/Bayes3.pdf}
}
\seealso{
\code{\link{getSavedata_Fileinfo}}, \code{\link{getSavedata_Data}}
}
\author{
Michael Hallquist, Florian Boeing-Messing
}
\keyword{internal}
