% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultOrdRS-package.R
\docType{package}
\name{MultOrdRS-package}
\alias{MultOrdRS-package}
\title{Model Multivariate Ordinal Responses Including Response Styles}
\description{
A model for multivariate ordinal responses. The response is modelled 
using a mixed model approach that is also capable of the inclusion 
of response style effects of the respondents.
}
\examples{
data(tenseness)

## create a small subset of the data to speed up calculations
set.seed(1860)
tenseness <- tenseness[sample(1:nrow(tenseness), 300),]

## scale all metric variables to get comparable parameter estimates
tenseness$Age <- scale(tenseness$Age)
tenseness$Income <- scale(tenseness$Income)

## two formulas, one without and one with explanatory variables (gender and age)
f.tense0 <- as.formula(paste("cbind(",paste(names(tenseness)[1:4],collapse=","),") ~ 1"))
f.tense1 <- as.formula(paste("cbind(",paste(names(tenseness)[1:4],collapse=","),") ~ Gender + Age"))



####
## Adjacent Categories Models
####

## Multivariate adjacent categories model, without response style, without explanatory variables
m.tense0 <- multordRS(f.tense0, data = tenseness, control = ctrl.multordRS(RS = FALSE, cores = 2))
m.tense0

\donttest{
## Multivariate adjacent categories model, with response style as a random effect, 
## without explanatory variables
m.tense1 <- multordRS(f.tense0, data = tenseness)
m.tense1

## Multivariate adjacent categories model, with response style as a random effect, 
## without explanatory variables for response style BUT for location
m.tense2 <- multordRS(f.tense1, data = tenseness, control = ctrl.multordRS(XforRS = FALSE))
m.tense2

## Multivariate adjacent categories model, with response style as a random effect, with 
## explanatory variables for location AND response style
m.tense3 <- multordRS(f.tense1, data = tenseness)
m.tense3

plot(m.tense3)



####
## Cumulative Models
####

## Multivariate cumulative model, without response style, without explanatory variables
m.tense0.cumul <- multordRS(f.tense0, data = tenseness, control = ctrl.multordRS(RS = FALSE), 
  model = "cumulative")
m.tense0.cumul

## Multivariate cumulative model, with response style as a random effect, 
## without explanatory variables
m.tense1.cumul <- multordRS(f.tense0, data = tenseness, model = "cumulative")
m.tense1.cumul

## Multivariate cumulative model, with response style as a random effect, 
## without explanatory variables for response style BUT for location
m.tense2.cumul <- multordRS(f.tense1, data = tenseness, control = ctrl.multordRS(XforRS = FALSE), 
  model = "cumulative")
m.tense2.cumul

## Multivariate cumulative model, with response style as a random effect, with 
## explanatory variables for location AND response style
m.tense3.cumul <- multordRS(f.tense1, data = tenseness, model = "cumulative")
m.tense3.cumul

plot(m.tense3.cumul)

################################################################
## Examples from Schauberger and Tutz (2020) 
## Data from the German Longitudinal Election Study (GLES) 2017
################################################################

####
## Source: German Longitudinal Election Study 2017 
## Rossteutscher et al. 2017, https://doi.org/10.4232/1.12927
####

## load GLES data
data(GLES17)

## scale data
GLES17[,7:11] <- scale(GLES17[,7:11])

## define formula
f.GLES <- as.formula(cbind(RefugeeCrisis, ClimateChange, Terrorism, 
                       Globalization, Turkey, NuclearEnergy) ~ 
                       Age + Gender + Unemployment + EastWest + Abitur)

## fit adjacent categories model without and with response style parameters
m.GLES0 <- multordRS(f.GLES, data = GLES17, control =  ctrl.multordRS(RS = FALSE, cores = 6))
m.GLES <- multordRS(f.GLES, data = GLES17, control =  ctrl.multordRS(cores = 6))

m.GLES0
m.GLES

plot(m.GLES, main = "Adjacent categories model")


## fit cumulative model without and with response style parameters (takes pretty long!!!)
m.GLES20 <- multordRS(f.GLES, data = GLES17,  model="cumul", 
control = ctrl.multordRS(opt.method = "nlminb", cores = 6, RS = FALSE))

m.GLES2 <- multordRS(f.GLES, data = GLES17,  model="cumul", 
control = ctrl.multordRS(opt.method = "nlminb", cores = 6))

m.GLES20
m.GLES2

plot(m.GLES2, main = "Cumulative model")

}
}
\references{
Schauberger, Gunther and Tutz, Gerhard (2021): Multivariate Ordinal Random Effects Models Including Subject and Group Specific Response Style Effects, 
\emph{Statistical Modelling}, \doi{10.1177/1471082X20978034}
}
\seealso{
\code{\link{multordRS}}  \code{\link{ctrl.multordRS}}  \code{\link{plot.MultOrdRS}}
}
\author{
Gunther Schauberger\cr \email{gunther.schauberger@tum.de}\cr
\url{https://orcid.org/0000-0002-0392-1580}
}
\keyword{adjacent}
\keyword{categories}
\keyword{cumulative}
\keyword{multivariate}
\keyword{ordinal}
\keyword{response}
\keyword{style}
